/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _MAIL_SERVER_H_
#define _MAIL_SERVER_H_

#include <glib.h>
#include <glib-object.h>
#include <libindicate/server.h>

#include "e-shell.h"

#define MAIL_TYPE_SERVER (mail_server_get_type ())

#define MAIL_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	MAIL_TYPE_SERVER, MailServer))

#define MAIL_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	MAIL_TYPE_SERVER, MailServerClass))

#define MAIL_IS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	MAIL_TYPE_SERVER))

#define MAIL_IS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	MAIL_TYPE_SERVER))

#define MAIL_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	MAIL_TYPE_SERVER, MailServerClass))

typedef struct _MailServer        MailServer;
typedef struct _MailServerClass   MailServerClass;
typedef struct _MailServerPrivate MailServerPrivate;
 
struct _MailServer
{
  IndicateServer      parent;	

  MailServerPrivate *priv;
};

struct _MailServerClass
{
  IndicateServerClass   parent_class;
};

GType mail_server_get_type                   (void) G_GNUC_CONST;

MailServer * mail_server_get_default (void);

guint        mail_server_get_message_count (MailServer *server);
void         mail_server_set_message_count (MailServer *server, 
                                            guint       count);
void         mail_server_set_e_shell       (MailServer *server,
                                            EShell     *shell);

#endif /* _MAIL_SERVER_H_ */
