/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * 	Module: ecetest.c
 */

/* the testing stub */


#include <pthread.h>
#include <clplumbing/ipc.h>
#include <clplumbing/GSource.h>
#include <clplumbing/Gmain_timeout.h>
#include <clplumbing/base64.h>
#include <plugin.h>
#include <ocf/oc_event.h>
#include "ece.h"
#include "eceinternal.h"
#include <string.h>
#include <assert.h>
#include <malloc.h>

ece_event_t *mdata=NULL;
size_t 	size;

static void 
mycb1(const ece_callback_class_t class, const size_t size, const void *data)
{
	ece_event_t *memdata = (ece_event_t *)data;
	ece_msg_t *msg = (ece_msg_t *)data;
	char *str;
	int i;

	//usleep(100);

	switch(class) {
		case CALLBACK_MEMBERSHIP:
			fprintf(stderr, "called mycb1 type=%d num_entries=%d\n", 
			memdata->type, memdata->num_entries);

			for (i=0; i< memdata->num_entries; i++) {
				fprintf(stderr, "%s\n", memdata->node[i].bytes);
			}
			fprintf(stderr, "-------------------\n");
			mdata= malloc(size);
			memcpy(mdata, memdata, size);
			break;
		case CALLBACK_MESSAGE:
			str = (char *)g_strndup((char *)msg->msg, msg->size);
			fprintf(stderr, "mycb1 message msg->node=%s, msg->core=%d,"
					"cmd=%d, size=%d data=%s\n",
					(char *)(msg->node.bytes),
					msg->corrolator,
					msg->cmd,
					msg->size,
					(char *)str);
			free(str);
			break;
	}

	return;
}

static void 
mycb(const ece_callback_class_t class, const size_t size, const void *data)
{
	ece_event_t *memdata = (ece_event_t *)data;
	ece_msg_t *msg = (ece_msg_t *)data;
	char *str;
	int i;

	//usleep(100);
	switch(class) {
		case CALLBACK_MEMBERSHIP:
			fprintf(stderr, "called mycb type=%d num_entries=%d\n", 
			memdata->type, memdata->num_entries);

			for (i=0; i< memdata->num_entries; i++) {
				fprintf(stderr, "%s\n", memdata->node[i].bytes);
			}
			fprintf(stderr, "-------------------\n");
			break;
		case CALLBACK_MESSAGE:
			str = (char *)g_strndup((char *)msg->msg, msg->size);
			fprintf(stderr, "mycb message msg->node=%s, msg->core=%d,"
					"cmd=%d, size=%d data=%s\n",
					(char *)(msg->node.bytes),
					msg->corrolator,
					msg->cmd,
					msg->size,
					(char *)str);
			free(str);
			break;
	}


	return;
}

int slave=0;
ece_mode_t
evms_engine_mode()
{
	if(slave) return SLAVE;
	return ENGINE_DAEMON;
}


/*--------------------------------------------------
 * Private Constants
 --------------------------------------------------*/
#define CRC_POLYNOMIAL     0xEDB88320L


/*--------------------------------------------------
 * Private Global Variables.
 --------------------------------------------------*/
static u_int32_t  CRC_table[ 256 ];

static boolean CRC_table_Built=FALSE;  /* TRUE=table is built, FALSE=table not built yet */

/*********************************************************************/
/*                                                                   */
/*   Function Name: build_CRC_table                                  */
/*                                                                   */
/*   Descriptive Name: This module implements the CRC function using */
/*                     a table driven method.  The required table    */
/*                     must be setup before the CalculateCRC function*/
/*                     can be used.  This table only needs to be set */
/*                     up once.  This function sets up the CRC table */
/*                     needed by CalculateCRC.                       */
/*                                                                   */
/*   Input: None                                                     */
/*                                                                   */
/*   Output: None                                                    */
/*                                                                   */
/*   Error Handling: N/A                                             */
/*                                                                   */
/*   Side Effects:  The internal CRC Table is initialized.           */
/*                                                                   */
/*   Notes:  None.                                                   */
/*                                                                   */
/*********************************************************************/
static void  build_CRC_table( void ) {
	u_int32_t   i, j, CRC;


	for (i = 0; i <= 255 ; i++) {

		CRC = i;

		for (j = 8 ; j > 0; j--) {

			if (CRC & 1)
				CRC = ( CRC >> 1 ) ^ CRC_POLYNOMIAL;
			else
				CRC >>= 1;
		}

		CRC_table[ i ] = CRC;

	}

	CRC_table_Built = TRUE;

}


/*********************************************************************/
/*                                                                   */
/*   Function Name: calculate_CRC                                    */
/*                                                                   */
/*   Descriptive Name: This function calculates the CRC value for    */
/*                     the data in the buffer specified by Buffer.   */
/*                                                                   */
/*   Input: CARDINAL32   CRC : This is the starting CRC.  If you are */
/*                             starting a new CRC calculation, then  */
/*                             this should be set to 0xFFFFFFFFL.  If*/
/*                             you are continuing a CRC calculation  */
/*                             (i.e. all of the data did not fit in  */
/*                             the buffer so you could not calculate */
/*                             the CRC in a single operation), then  */
/*                             this is the CRC output by the last    */
/*                             CalculateCRC call.                    */
/*                                                                   */
/*   Output: The CRC for the data in the buffer, based upon the value*/
/*           of the input parameter CRC.                             */
/*                                                                   */
/*   Error Handling: None.                                           */
/*                                                                   */
/*   Side Effects:  None.                                            */
/*                                                                   */
/*   Notes:  None.                                                   */
/*                                                                   */
/*********************************************************************/
u_int32_t   calculate_CRC( u_int32_t CRC, void * Buffer, u_int32_t buffer_size) {
	u_char  * current_byte;
	u_int32_t temp1, temp2, I;


	current_byte = ( u_char *) Buffer;

	/* Make sure the CRC table is available */
	if (CRC_table_Built==FALSE)  build_CRC_table();

	/* Process each byte in the buffer. */
	for (I = 0; I < buffer_size; I++) {

		temp1 = (CRC >> 8) & 0x00FFFFFFL;
		temp2 = CRC_table[ ( CRC ^ (u_int32_t) *current_byte ) & (u_int32_t) 0xff ];
		current_byte++;
		CRC = temp1 ^ temp2;
	}

	return( CRC );
}




extern plugin_record_t ece_plugin_record;

int test_write_log_entry(debug_level_t level, 
		 	plugin_record_t *plugin,
			char		*fmt,
			...)
{

	return 0;
}
engine_functions_t engine_functions = {
	get_engine_plugin_api_version: NULL,
	get_plugin_list:               NULL,
	get_plugin_by_ID:              NULL,
	get_plugin_by_name:            NULL,
	get_volume_list:               NULL,
	get_object_list:               NULL,
	get_container_list:            NULL,
	allocate_logical_disk:         NULL,
	free_logical_disk:             NULL,
	allocate_segment:              NULL,
	free_segment:                  NULL,
	allocate_container:            NULL,
	free_container:                NULL,
	allocate_region:               NULL,
	free_region:                   NULL,
	allocate_evms_object:          NULL,
	free_evms_object:              NULL,
	open_object:                   NULL,
	read_object:                   NULL,
	write_object:                  NULL,
	ioctl_object:                  NULL,
	close_object:                  NULL,
	engine_alloc:                  NULL,
	engine_free:                   NULL,
	commit_in_progress:            NULL,
	write_log_entry:               test_write_log_entry,
	calculate_CRC:                 calculate_CRC,
	calculate_checksum:            NULL,
	add_sectors_to_kill_list:      NULL,
	validate_name:                 NULL,
	register_name:                 NULL,
	unregister_name:               NULL,
	can_expand_by:                 NULL,
	can_shrink_by:                 NULL,
	user_message:                  NULL,
	user_communication:            NULL,
	progress:                      NULL,
	can_rename:                    NULL,
	is_mounted:                    NULL,
	assign_fsim_to_volume:         NULL,
	unassign_fsim_from_volume:     NULL,
	get_engine_mode:               evms_engine_mode,
	dm_allocate_target:            NULL,
	dm_add_target:                 NULL,
	dm_deallocate_targets:         NULL,
	dm_activate:                   NULL,
	dm_deactivate:                 NULL,
	dm_rename:                     NULL,
	dm_update_status:              NULL,
	dm_get_targets:                NULL,
	get_config_bool:               NULL,
	get_config_uint32:             NULL,
	get_config_uint32_array:       NULL,
	get_config_uint64:             NULL,
	get_config_uint64_array:       NULL,
	get_config_string:             NULL,
	get_config_string_array:       NULL,
	get_clusterid:                 NULL,
	get_nodeid:                    NULL,
	nodeid_to_string:              NULL,
	string_to_nodeid:              NULL
};


void
ece_check_memoryleak(void)
{
        /* check for memory leaks */
        struct mallinfo i;
        static int arena=0;
        i = mallinfo();
        if(arena==0) {
               arena = i.arena;
        } else if(arena < i.arena) {
                fprintf(stderr, "***********LEAKING MEMORY? PREVIOUS ARENA=%d*********** " 
				"present arena=%d", arena, i.arena);
		arena=i.arena;
	}
}


#define OPTARGS "s"
int
main(int argc, char **argv)
{
	ece_msg_t msg;
	int flag;
	ece_nodeid_t nodeid;
	ece_nodeid_t *nodes;
	uint num,i;
	cluster_functions_t * ece_funcs;
	uint lenth;
	int ret;
	char str[256];
	int itt=0;

	
	build_CRC_table();


	ece_funcs = ece_plugin_record.functions.cluster;

	while ((flag = getopt(argc, argv, OPTARGS)) != EOF) {
		switch(flag) {
		case 's':
			slave = 1;
			break;
		default:
			fprintf(stderr,"%s -m",argv[0]);
			return 1;
		}
	}

	while(1) {

	if(ece_funcs->setup_evms_plugin(&engine_functions) == ENODEV){
		fprintf(stderr, "no ece service availbale\n");
		return 1;
	}
	
	ece_funcs->register_callback(DELTAS, mycb);
	ece_funcs->register_callback(FULL_MEMBERSHIP, mycb1);

	while(mdata == NULL) {
		fprintf(stderr,"hi\n");
		sleep(1);
	}
	
	memcpy(&msg.node, mdata->node, sizeof(msg.node));
	
	//msg.node = (ece_nodeid_t)ECE_ALL_NODES;
	/*for(i=0;i<30000;i++){
		((char *)(msg.msg))[i] = ('a'+ i%26);
	}
	((char *)(msg.msg))[29999] = '\0';
	printf("%s\n",(char *)(msg.msg));*/
	i=0;
	while ( i < 100 ) {
		printf("%s\n",(char *)&(msg.node));
		msg.corrolator = 0;
		msg.cmd =10000;
		msg.msg = (char *)g_malloc0(30000);
		msg.size =30000;

		//sleep(3);

		if((ret = ece_funcs->send_msg(&msg))){
			fprintf(stderr,"send failed ret=%d\n",ret);
			sleep(3);
		}
		i++;
		g_free(msg.msg);
		ece_check_memoryleak();
	}

	fprintf(stderr," *****************MALLINFO***************** = %d \n",
			mallinfo().arena);

	
	if(ece_funcs->get_my_nodeid(&nodeid)) {
		fprintf(stderr,"get my nodeid failed \n");
	}
	lenth = 256;
	ece_funcs->nodeid_to_string(&nodeid, str, (uint *)&lenth);
	ece_funcs->get_num_config_nodes(&num);
	fprintf(stderr, "nodeid=%s str=%s maxnodes=%d\n", (char *)&nodeid, str, num);

	{
		ece_funcs->string_to_nodeid(str, &nodeid);
		fprintf(stderr, "nodeid is %s\n", (char *)&nodeid);
	}

	nodes = g_malloc(num*sizeof(ece_nodeid_t));
	ece_funcs->get_all_nodes(&num, nodes);
	for ( i = 0; i < num ; i++ ) {
		uint lth = 256;
		ece_funcs->nodeid_to_string(nodes+i, str, (uint *)&lth);
		fprintf(stderr, "nodes[%d]=%s\n", i, str);
	}

	{
	int sz = sizeof(ece_event_t)+num*sizeof(ece_nodeid_t);
	ece_event_t *ev = g_malloc(sz);
	ev->num_entries = num;
	fprintf(stderr, "membership is \n");
	if(ece_funcs->get_membership(ev) == 0)
		mycb1(CALLBACK_MEMBERSHIP, sz, ev);
	}

	{
	ece_clusterid_t cluster;
	ece_funcs->get_clusterid(&cluster);
	fprintf(stderr, "clusterid is %s\n", (char *)&cluster);
	}



	/*while(1);*/ /* loop for ever */
	sleep(5);
	ece_funcs->unregister_callback(mycb1);

	ece_funcs->cleanup_evms_plugin();

	fprintf(stderr, "endof %dth itteration\n", itt++);
	}


	/*if(ece_funcs->setup_evms_plugin(&engine_functions) == ENODEV){*/
                /*fprintf(stderr, "no ece service availbale\n");*/
                /*return 1;*/
        /*}*/
/**/
        /*ece_funcs->register_callback(DELTAS, mycb);*/
        /*ece_funcs->register_callback(FULL_MEMBERSHIP, mycb1);*/


	//start_ece((void *)mainloop);
	return 0;
}
/* END OF NONLIBRARY RELATED TEST FUNCTIONS */
