/*
 *
 *    Copyright 1995-1999 Regents of the University of Minnesota
 *    Portions Copyright 2001 Sistina Software, Inc.
 *    Portions Copyright 2001 The OpenGFS Project.
 *
 *    This is free software released under the GNU General Public License.
 *    There is no warranty for this software.  See the file COPYING for
 *    details.
 *
 *    See the file AUTHORS for a list of contributors.
 *
 */

/*
 *      Globally used header for OGFS, pool, etc.
 */
#ifndef _GLOBAL_H
#define _GLOBAL_H

#ifdef __cplusplus
extern "C" {
#endif


#ifndef BPKB
#define	BPKB (10)	/* Bits per kilobyte */
#define KBSHIFT	BPKB
#endif

#if !defined(KILOBYTE)
#define KILOBYTE	((__uint32_t)(       1 << KBSHIFT))
#endif

#if !defined(MEGABYTE)
#define MEGABYTE	((__uint32_t)(KILOBYTE << KBSHIFT))
#endif

#if !defined(GIGABYTE)
#define GIGABYTE	((__uint32_t)(MEGABYTE << KBSHIFT))
#endif

#if !defined(TERABYTE)
#define TERABYTE	(1099511627776LLU)
#endif

#if !defined(PETABYTE)
#define PETABYTE	(1125899906842624LLU)
#endif

#ifndef TRUE
#define TRUE (1)
#endif

#ifndef FALSE
#define FALSE (0)
#endif


#include <stdint.h>
#define BITS_PER_LONG __WORDSIZE

#if (BITS_PER_LONG == 64)
#define FMT_64 "l"
#else
#define FMT_64 "L"
#endif


typedef uint64_t          uint64;
typedef uint32_t          uint32;
typedef uint16_t          uint16;
typedef uint8_t           uint8;
typedef int64_t           int64;
typedef int32_t           int32;
typedef int16_t           int16;
typedef int8_t            int8;



struct debug_desc
{
  const char             *name;
  const unsigned int     len;
  const unsigned int     *flag;
};
typedef struct debug_desc debug_desc_t;



#ifdef __cplusplus
}
#endif

#endif /* _GLOBAL_H */
