/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * File: replace.h
 *
 */

/*
 * Ok, it's not really a device manager.  We use the device manager plug-in type
 * so that the plug-in gets called only once during discovery.  On discovery,
 * the replace plug-in finds any old device-mapper mirror maps that were used
 * for replace and removes the maps.  Segment managers and region managers can
 * get called multiple times.  It would be a waste to call the replace plug-in
 * several times during discovery.  EVMS features only get called for discovery
 * if an object has a feature header and the feature header has the plug-in's
 * ID.  The replace plug-in should always be called on discovery, so being a
 * feature won't do.
 */
#define REPLACE_PLUGIN_ID	(SetPluginID(EVMS_OEM_IBM, EVMS_DEVICE_MANAGER, 12))


#define FEATURE_HEADER_SECTORS ((sizeof(evms_feature_header_t) + EVMS_VSECTOR_SIZE - 1) / EVMS_VSECTOR_SIZE)
#define EVMS_VOLUME_FEATURE_ID (SetPluginID(IBM_OEM_ID, EVMS_FEATURE, 0))


/*
 * Convert a feature header in the CPU endian format to the disk endian
 * (little endian) format.
 */
static inline void feature_header_cpu_to_disk(evms_feature_header_t * fh) {

	fh->signature                 = CPU_TO_DISK32(fh->signature);
	fh->version.major             = CPU_TO_DISK32(fh->version.major);
	fh->version.minor             = CPU_TO_DISK32(fh->version.minor);
	fh->version.patchlevel        = CPU_TO_DISK32(fh->version.patchlevel);
	fh->engine_version.major      = CPU_TO_DISK32(fh->engine_version.major);
	fh->engine_version.minor      = CPU_TO_DISK32(fh->engine_version.minor);
	fh->engine_version.patchlevel = CPU_TO_DISK32(fh->engine_version.patchlevel);
	fh->flags                     = CPU_TO_DISK32(fh->flags);
	fh->feature_id                = CPU_TO_DISK32(fh->feature_id);
	fh->sequence_number           = CPU_TO_DISK64(fh->sequence_number);
	fh->alignment_padding         = CPU_TO_DISK64(fh->alignment_padding);
	fh->feature_data1_start_lsn   = CPU_TO_DISK64(fh->feature_data1_start_lsn);
	fh->feature_data1_size        = CPU_TO_DISK64(fh->feature_data1_size);
	fh->feature_data2_start_lsn   = CPU_TO_DISK64(fh->feature_data2_start_lsn);
	fh->feature_data2_size        = CPU_TO_DISK64(fh->feature_data2_size);
	fh->volume_serial_number      = CPU_TO_DISK64(fh->volume_serial_number);
	fh->volume_system_id          = CPU_TO_DISK32(fh->volume_system_id);
	fh->object_depth              = CPU_TO_DISK32(fh->object_depth);
}

