/*
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: mdregmgr
 * File: raid1_discover.h
 */

#ifndef _RAID1_MGR_H_
#define _RAID1_MGR_H_ 1


// create options:
#define MD_OPTION_SPARE_DISK_INDEX  	0
#define MD_OPTION_SPARE_DISK_NAME	"sparedisk"
#define MD_NO_SELECTION			"None"

#define RAID1_EXPAND	1
#define RAID1_SHRINK	2
//
// Expand Option Info
//
#define RAID1_EXPAND_OPTION_COUNT                     1

#define RAID1_EXPAND_OPTION_SIZE_INDEX                0
#define RAID1_EXPAND_OPTION_SIZE_NAME                 "Size"
#define RAID1_MINIMUM_EXPAND_SIZE			(2 * 1024)


//
// Shrink Option Info
//
#define RAID1_SHRINK_OPTION_COUNT                     1

#define RAID1_SHRINK_OPTION_SIZE_INDEX                0
#define RAID1_SHRINK_OPTION_SIZE_NAME                 "Size"
#define RAID1_MINIMUM_SHRINK_SIZE			(2 * 1024)
#define RAID1_PERCENT_SHRINK_THRESHOLD		90

// Plug-in functions
#define MD_RAID1_FUNCTION_FIX			EVMS_Task_Plugin_Function
#define MD_RAID1_FUNCTION_ADD_SPARE		(EVMS_Task_Plugin_Function + 1)
#define MD_RAID1_FUNCTION_ADD_ACTIVE		(EVMS_Task_Plugin_Function + 2)
#define MD_RAID1_FUNCTION_ACTIVATE_SPARE  	(EVMS_Task_Plugin_Function + 3)
#define MD_RAID1_FUNCTION_REMOVE_SPARE  	(EVMS_Task_Plugin_Function + 4)
#define MD_RAID1_FUNCTION_DEACTIVATE_ACTIVE 	(EVMS_Task_Plugin_Function + 5)
#define MD_RAID1_FUNCTION_REMOVE_ACTIVE 	(EVMS_Task_Plugin_Function + 6)
#define MD_RAID1_FUNCTION_REMOVE_FAULTY 	(EVMS_Task_Plugin_Function + 7)
#define MD_RAID1_FUNCTION_MARK_FAULTY 		(EVMS_Task_Plugin_Function + 8)
#define MD_RAID1_FUNCTION_REMOVE_STALE	 	(EVMS_Task_Plugin_Function + 9)
#define MD_RAID1_RESTORE_SUPERBLOCK		(EVMS_Task_Plugin_Function + 10)

#define MD_RAID1_FUNCTION_COUNT			11

/* RAID1 region manager flag */

#define MD_RAID1_CONFIG_CHANGE_PENDING		(1<<0)
#define MD_RAID1_REGION_NEW			(1<<1)
#define MD_RAID1_IGNORE_VERIFY			(1<<2)

static inline boolean raid1_region_config_change_pending(md_volume_t *vol)
{
	return (vol->region_mgr_flags & MD_RAID1_CONFIG_CHANGE_PENDING);
}

static inline boolean raid1_region_new(md_volume_t *vol)
{
	return (vol->region_mgr_flags & MD_RAID1_REGION_NEW);
}


/* RAID1 plugin functions */

int add_active_disk(md_volume_t * volume, storage_object_t * new_disk);
int remove_active_disk(md_volume_t * volume, storage_object_t *active_disk);

int activate_spare_disk(md_volume_t * volume, storage_object_t * spare_disk);
int deactivate_active_disk(md_volume_t * volume, storage_object_t * active_disk);

int add_spare_disk(md_volume_t * volume, storage_object_t * spare_disk);
int remove_spare_disk(md_volume_t * volume, storage_object_t * spare);

int raid1_mark_disk_faulty(md_volume_t * volume, storage_object_t * active_disk);

int raid1_fix_array(md_volume_t *volume);
int remove_faulty_disk(md_volume_t * volume, storage_object_t * faulty_disk);
int remove_stale_disk(md_volume_t * volume, storage_object_t * stale_disk);

#endif

