/*
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: mdregmgr
 * File: md_dlist.h
 */

#ifndef _MD_DLIST_H_
#define _MD_DLIST_H_ 1

#define MD_IOCTL_TAG 99
#define MD_SETUP_TAG 100

#define EVMS_MD_ADD			1	/* hot add */
#define EVMS_MD_REMOVE			2	/* hot remove */
#define EVMS_MD_ACTIVATE		3
#define EVMS_MD_DEACTIVATE		4	/* mark disk faulty */
#define EVMS_MD_ACTIVATE_REGION		5
#define EVMS_MD_DEACTIVATE_REGION	6
#define EVMS_MD_GENERIC_CMD		7
#define EVMS_MD_INVOKE_CALLBACK		9
#define EVMS_MD_CANCEL_OPERATION	10	/* Caller should cancel the sheduled iotcl*/


typedef struct evms_md_disk_info_s {
	u_int32_t number;
	u_int32_t major;
	u_int32_t minor;
	storage_object_t *object;
} evms_md_disk_info_t;
	
union evms_md_ioctl_parm {
	evms_md_disk_info_t * disk_info;	/* for EVMS_MD_ADD and EVMS_MD_REMOVE */
	mdp_super_t *sb;			/* for EVMS_MD_ACTIVATE_REGION */
};
typedef union evms_md_ioctl_parm evms_md_ioctl_parm_t;

/*
 * FIFO Queue of MD ioctl packages
 */
typedef struct md_ioctl_pkg_s {
	int cmd;
	evms_md_ioctl_parm_t parm;
	int rc;
	int (*callback_func)(md_volume_t *volume, struct md_ioctl_pkg_s *pkg);
} md_ioctl_pkg_t;

typedef int (md_ioctl_callback_t)(md_volume_t *volume, struct md_ioctl_pkg_s *pkg);

/*
 * Structure to hold pre-ioctl setup functions
 */
typedef struct md_setup_func_s {
	boolean proceed;
	evms_md_disk_info_t * disk_info;
	int (*setup_func)(md_volume_t *volume, struct md_setup_func_s *setup);
} md_setup_func_t;

typedef int (setup_func_t)(md_volume_t *volume, struct md_setup_func_s *setup);


// Functions exported from md_dlist.c
int md_append_region_to_object(storage_object_t	* region,
			       storage_object_t	* object );
void md_remove_region_from_object(storage_object_t	* region,
				  storage_object_t	* object );
void md_clear_child_list( storage_object_t * region, list_anchor_t children );
int md_add_object_to_list( storage_object_t	* object,
			   list_anchor_t	objects );
int md_transfer_list( list_anchor_t	input,
		      list_anchor_t	output );

void md_remove_volume_from_list(md_volume_t * volume);
void md_add_volume_to_list(md_volume_t * volume);

int schedule_setup_func(md_volume_t *volume,
			evms_md_disk_info_t *disk_info,
			setup_func_t *setup_func);

int process_setup_funcs(storage_object_t *region);
void empty_setup_funcs_queue(md_volume_t *vol);


int schedule_md_ioctl_pkg(md_volume_t * vol,
			  int cmd,
			  evms_md_ioctl_parm_t *parm,
			  md_ioctl_callback_t *callback);
boolean remove_scheduled_md_ioctl_pkg(md_volume_t * vol,
				      int cmd,
				      evms_md_ioctl_parm_t *parm);

int process_md_ioctl_pkgs(storage_object_t *region);
void empty_ioctl_queue(md_volume_t *vol);
void free_ioctl_pkgs(md_volume_t *vol);
#endif

