/*
 *
 *   (C) Copyright IBM Corp. 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libmac.so
 *
 *   File: mac_plugin.c
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include <plugin.h>

#include "mac_plugin.h"

/*-------------------------------------------------------------------------------------+
+                                                                                      +
+                         PRIVATE DATA AREAS AND SUBROUTINES                           +
+                                                                                      +
+-------------------------------------------------------------------------------------*/

static plugin_record_t          mac_plugin_record;

plugin_record_t                *mac_plugin = &mac_plugin_record;

struct engine_functions_s      *EngFncs=NULL;


/*-------------------------------------------------------------------------------------+
+                                                                                      +
+                          Plugin Setup and Cleanup Functions                          +
+                                                                                      +
+--------------------------------------------------------------------------------------*/
static int mac_setup( engine_functions_t * engine_functions )
{
        int rc = EINVAL;

        if (engine_functions) {
                engine_functions->write_log_entry( ENTRY_EXIT,
                                                   mac_plugin,
                                                   "mac_setup: entry\n");
                EngFncs = engine_functions;
                rc = 0;
        }

        LOG_EXIT_INT(rc);
        return rc;
}

static void mac_cleanup(void)
{
        LOG_ENTRY();

        delete_all_mac_segment_private_data();
        delete_all_mac_disk_private_data();

        LOG_EXIT_VOID();
}

/*-------------------------------------------------------------------------------------+
+                                                                                      +
+                              PLUGIN FUNCTION TABLE                                   +
+                                                                                      +
+--------------------------------------------------------------------------------------*/
static struct plugin_functions_s mac_plugin_functions = {
        setup_evms_plugin:              mac_setup,
        cleanup_evms_plugin:            mac_cleanup,
        can_set_volume:                 mac_can_set_volume,
        can_delete:                     mac_can_delete,
        can_expand:                     mac_can_expand,
        can_expand_by:                  mac_can_expand_by,
        can_shrink:                     mac_can_shrink,
        can_shrink_by:                  mac_can_shrink_by,
        discover:                       mac_discover,
        assign:                         mac_assign,
        can_unassign:                   mac_can_unassign,
        unassign:                       mac_unassign,
        create:                         mac_create,
        delete:                         mac_destroy,
        discard:                        mac_discard,
        expand:                         mac_expand,
        shrink:                         mac_shrink,
        add_sectors_to_kill_list:       mac_add_sectors_to_kill_list,
        commit_changes:                 mac_commit_changes,
        read:                           mac_read,
        write:                          mac_write,
        set_volume:                     mac_set_volume,
        get_option_count:               mac_get_option_count,
        init_task:                      mac_init_task,
        set_option:                     mac_set_option,
        set_objects:                    mac_set_objects,
        get_info:                       mac_get_info,
        get_plugin_info:                mac_get_plugin_info,
        activate:                       mac_activate,
        deactivate:                     mac_deactivate
};


/*-------------------------------------------------------------------------------------+
+                                                                                      +
+                       BUILD AND EXPORT AN EVMS PLUGIN RECORD                         +
+                                                                                      +
+--------------------------------------------------------------------------------------*/

static plugin_record_t mac_plugin_record = {

        id:                                 SetPluginID(EVMS_OEM_IBM, EVMS_SEGMENT_MANAGER, 8 ),

        version:                            {MAJOR_VERSION, MINOR_VERSION, PATCH_LEVEL},

        required_engine_api_version:        {13,0,0},
        required_plugin_api_version:        {plugin: {12,0,0}},
        required_container_api_version:     {9,0,0},

        short_name:                         "MAC",
        long_name:                          "MAC Segment Manager",
        oem_name:                           "IBM",

        functions:                          {plugin: &mac_plugin_functions},

};

// Vector of plugin record ptrs that we export for the EVMS Engine.
plugin_record_t *evms_plugin_records[] = {
        &mac_plugin_record,
        NULL
};


