/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: bbr.h
 *
 */

#ifndef BAD_BLOCK_RELOCATION_HEADER
#define BAD_BLOCK_RELOCATION_HEADER

#define EVMS_BBR_VERSION_MAJOR            1
#define EVMS_BBR_VERSION_MINOR            0
#define EVMS_BBR_VERSION_PATCHLEVEL       0

#define EVMS_BBR_FEATURE_ID       6
#define EVMS_BBR_SIGNATURE        0x42627253   /* BbrS */


#define BBR_ENABLED  0x0001
#define BBR_CHANGE_STATE 0x0010
#define BBR_ACTIVATE 0x0030

#define BBR_FUNCTION_ENABLE EVMS_Task_Plugin_Function
#define BBR_FUNCTION_DISABLE ( EVMS_Task_Plugin_Function + 1 )

/* The following defines establish the minimum and maximum number of
 * replacement sectors which can be allocated for Bad Block Relocation.
 * Otherwise, 1 replacement sector per MB of disk space is allocated. */
#define EVMS_BBR_ENTRIES_PER_SECT    31 /* Assume sector size is 512 bytes*/
#define EVMS_BBR_LIMIT  4096

#define EVMS_BBR_TABLE_SIGNATURE         0x42627254 /* BbrT */

typedef struct evms_bbr_table_entry {
    u_int64_t bad_sect;
    u_int64_t replacement_sect;
} evms_bbr_table_entry_t;

typedef struct evms_bbr_table {
    u_int32_t signature;                /* Signature for a sector of the bbr table (EVMS_BBR_TABLE_SIGNATURE) */
    u_int32_t crc;                      /* CRC for this sector of the BBR Table. */
    u_int32_t sequence_number;          /* Used to resolve conflicts when the primary and secondary tables do not match. */
    u_int32_t in_use_cnt;               /* number of in-use entries */
    evms_bbr_table_entry_t entries[EVMS_BBR_ENTRIES_PER_SECT];   /* BBR table entries available for this sector of the BBR table */
} evms_bbr_table_t;

/* description of on disk meta data sector for bbr feature */
typedef struct evms_bbr_metadata {
/* 0*/        u_int32_t signature;                /* EVMS_BBR_SIGNATURE */
/* 4*/        u_int32_t crc;
/* 8*/        u_int32_t block_size;               /* block size in bytes */
/*12*/        u_int32_t flags;                    /* Global flag used by BBR */
/*16*/        u_int64_t sequence_number;
/*24*/        u_int64_t start_sect_bbr_table;     /* start 64-bit LBA of the BBR table */
/*32*/        u_int64_t nr_sects_bbr_table;       /* number of sectors to hold the BBR table */
/*40*/        u_int64_t start_replacement_sect;   /* start 64-bit LBA of the replacement sectors */
/*48*/        u_int64_t nr_replacement_blks;      /* number of replacement blocks. */
/*56*/        u_int32_t bbr_active;
/*60*/        char      uuid[EVMS_NAME_SIZE+1];
/*188*/       char      pads[322];
/*512*/
} evms_bbr_metadata_t;


typedef struct _guid_s {
    u_int32_t       time_low;       // timestamp - low order 32 bits
    u_int16_t       time_mid;       // timestamp - mid 16 bits
    u_int16_t       time_high;      // timestamp - high 16 bits
    u_int8_t        clock_seq_high; // clock - high order 8 bits
    u_int8_t        clock_seq_low;  // clock - low order 8 bits
    u_int8_t        node[6];        // node - spatial reference - unique identification like
} __attribute__((packed)) guid_t;   // the mac address of this systems network card.

#define SECTOR_IO_READ	0
#define SECTOR_IO_WRITE	1

typedef struct evms_notify_bbr {
	char		object_name[EVMS_VOLUME_NAME_SIZE+1];	// Input  - Name of bbr object from feature header
	uint64_t	count;		// Output - Count of remapped sectors
	uint64_t	start_sect;	// Input - Starting sector for sector_io
	uint64_t	nr_sect;	// Input - Number of sectors for sector_io
	uint8_t *	buffer;		// Input - Pointer to buffer for sector_io
	int32_t		rw;		// Input - READ or WRITE for sector_io
} evms_notify_bbr_t;

extern plugin_record_t		*my_plugin_record;
extern engine_functions_t	*EngFncs;

// need an object that is exactly 1 sector in size;
typedef struct vsector_s {
    char  one_sector[EVMS_VSECTOR_SIZE];
} vsector_t;

// macro to pull the BBR child object ptr from the BBR private data area
#define GET_BBR_CHILD( bbrobject ) ((BBR_Private_Data *)bbrobject->private_data)->child

// minimum number of replacement blocks to use for a partition (roughly 2 tracks)
#define BBR_MIN_REPLACEMENT_BLOCKS  128

// maximum number of replacement blocks to use for a partition (roughly 65 tracks)
#define BBR_MAX_REPLACEMENT_BLOCKS  2048

 
typedef struct kill_sectors_s {
	lsn_t                   lsn;
	sector_count_t          count;
	struct kill_sectors_s * next;
} kill_sectors_t;


// BBR storage object private data area
typedef struct _bbr_pdata {

    // private data can be verified by this signature
    u_int32_t                   signature;

    // child object that we consumed
    storage_object_t           *child;

    // Replacement Blocks information
    u_int64_t                   replacement_blocks_lsn;
    u_int64_t                   replacement_blocks_needed;
    u_int64_t                   replacement_blocks_size_in_sectors;

    // BBR1 Table information
    u_int64_t                   bbr_table_lsn1;
    u_int64_t                   bbr_table_lsn2;
    u_int64_t                   bbr_table_size_in_sectors;
    evms_bbr_table_t           *bbr_table;

    // feature data information
    u_int64_t                   sequence_number;

    // Block size
    u_int32_t                   block_size;

    u_int32_t bbr_state; //disabled or enabled, change
    kill_sectors_t * kill_sector_list_head;
    
} BBR_Private_Data;


// EVMS functions exported by the BBR shared object
int             get_bbr_disk_info( storage_object_t *child, geometry_t *geometry );
int             PluginInit( plugin_record_t *pPlugRec );
void            PluginCleanup( plugin_record_t *pPlugRec);


#endif
