/*******************************************************************************
 *Copyright (c) 2009 Eucalyptus Systems, Inc.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, only version 3 of the License.
 * 
 * 
 * This file is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 * Please contact Eucalyptus Systems, Inc., 130 Castilian
 * Dr., Goleta, CA 93101 USA or visit <http://www.eucalyptus.com/licenses/>
 * if you need additional information or have any questions.
 * 
 * This file may incorporate work covered under the following copyright and
 * permission notice:
 * 
 * Software License Agreement (BSD License)
 * 
 * Copyright (c) 2008, Regents of the University of California
 * All rights reserved.
 * 
 * Redistribution and use of this software in source and binary forms, with
 * or without modification, are permitted provided that the following
 * conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. USERS OF
 * THIS SOFTWARE ACKNOWLEDGE THE POSSIBLE PRESENCE OF OTHER OPEN SOURCE
 * LICENSED MATERIAL, COPYRIGHTED MATERIAL OR PATENTED MATERIAL IN THIS
 * SOFTWARE, AND IF ANY SUCH MATERIAL IS DISCOVERED THE PARTY DISCOVERING
 * IT MAY INFORM DR. RICH WOLSKI AT THE UNIVERSITY OF CALIFORNIA, SANTA
 * BARBARA WHO WILL THEN ASCERTAIN THE MOST APPROPRIATE REMEDY, WHICH IN
 * THE REGENTS’ DISCRETION MAY INCLUDE, WITHOUT LIMITATION, REPLACEMENT
 * OF THE CODE SO IDENTIFIED, LICENSING OF THE CODE SO IDENTIFIED, OR
 * WITHDRAWAL OF THE CODE CAPABILITY TO THE EXTENT NEEDED TO COMPLY WITH
 * ANY SUCH LICENSES OR RIGHTS.
 *******************************************************************************/
/*
 * Author: chris grzegorczyk <grze@eucalyptus.com>
 */
package com.eucalyptus.ws.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.http.HttpRequest;

import com.eucalyptus.util.DebugUtil;
import com.eucalyptus.ws.client.NioMessageReceiver;
import com.eucalyptus.ws.handlers.ServiceSinkHandler;
import com.eucalyptus.ws.stages.UnrollableStage;
import com.eucalyptus.ws.util.ChannelUtil;

import edu.ucsb.eucalyptus.constants.EventType;
import edu.ucsb.eucalyptus.msgs.EventRecord;

public abstract class FilteredPipeline implements Comparable<FilteredPipeline> {
  private static Logger               LOG    = Logger.getLogger( FilteredPipeline.class );
  private final List<UnrollableStage> stages = new ArrayList<UnrollableStage>( );
  private NioMessageReceiver          msgReceiver;
  
  public FilteredPipeline( ) {
    this.addStages( this.stages );
  }
  
  public FilteredPipeline( final NioMessageReceiver msgReceiver ) {
    this.addStages( this.stages );
    this.msgReceiver = msgReceiver;
  }
  
  public boolean accepts( final HttpRequest message ) {
    final boolean result = this.checkAccepts( message );
    if ( result && DebugUtil.TRACE ) {
      LOG.trace( EventRecord.here( this.getClass(), EventType.PIPELINE_UNROLL, this.getClass( ).getSimpleName( ) ) );
    }
    return result;
  }
  
  @Override
  public int compareTo( final FilteredPipeline o ) {
    return ( this.getClass( ).getCanonicalName( ) + this.getPipelineName( ) ).compareTo( ( o.getClass( ).getCanonicalName( ) + o.getPipelineName( ) ) );
  }
  
  public abstract String getPipelineName( );
  
  public List<UnrollableStage> getStages( ) {
    return this.stages;
  }
  
  public void unroll( final ChannelPipeline pipeline ) {
    try {
      for ( final UnrollableStage s : this.stages ) {
//        pipeline.addLast( "pre-" + s.getStageName( ), new UnrollableStage.StageBottomHandler( s ) );
        s.unrollStage( pipeline );
//        pipeline.addLast( "post-" + s.getStageName( ), new UnrollableStage.StageTopHandler( s ) );
      }
      if ( this.msgReceiver != null ) {
        pipeline.addLast( "service-sink", new ServiceSinkHandler( this.msgReceiver ) );
      } else {
        pipeline.addLast( "service-sink", new ServiceSinkHandler( ) );
      }
      if( DebugUtil.TRACE ) {
        for ( final Map.Entry<String, ChannelHandler> e : pipeline.toMap( ).entrySet( ) ) {
          LOG.trace( EventRecord.here( this.getClass(), EventType.PIPELINE_HANDLER, e.getKey(), e.getValue( ).getClass( ).getSimpleName( ) ) );
        }
      }
    } catch ( final Exception e ) {
      LOG.error( "Error unrolling pipeline: " + this.getPipelineName( ) );
      final ChannelFuture close = pipeline.getChannel( ).close( );
      close.awaitUninterruptibly( );
      LOG.error( "Forced pipeline to close due to exception: ", e );
    }
  }
  
  protected abstract void addStages( List<UnrollableStage> stages );
  
  protected abstract boolean checkAccepts( HttpRequest message );
  
}