# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Author: Olivier Tilloy <olivier@fluendo.com>

from elisa.plugins.pigment.widgets.widget import Widget
from elisa.plugins.pigment.widgets.theme import Theme
from elisa.plugins.pigment.widgets import entry

from elisa.plugins.pigment.graph.image import Image

from elisa.plugins.poblesec.widgets.sliced_image import SlicedImageHorizontal

import pgm


class EntryField(entry.Entry):

    def __init__(self):
        super(EntryField, self).__init__()
        self._text.bg_color = (0, 0, 0, 0)
        self._text.fg_color = (255, 255, 255, 255)
        self._text.size = (self.width - 0.04, self.height - 0.4)
        self._text.position = (0.02, 0.2, 0.01)
        self._set_frame()
        self.focus_on_click = True

    def _set_frame(self):
        self._frame = SlicedImageHorizontal()
        self.add(self._frame)
        theme = Theme.get_default()
        left_cap = theme.get_resource('elisa.plugins.poblesec.entry_field_left_cap')
        right_cap = theme.get_resource('elisa.plugins.poblesec.entry_field_right_cap')
        body = theme.get_resource('elisa.plugins.poblesec.entry_field_body')
        self._frame.left_cap.set_from_file(left_cap)
        self._frame.right_cap.set_from_file(right_cap)
        self._frame.body.set_from_file(body)
        self._frame.position = (0.0, self.height * 0.1, 0.0)
        self._frame.size = (self.width, self.height * 0.8)
        self._frame.visible = True


class SearchEntryField(EntryField):

    def __init__(self):
        super(SearchEntryField, self).__init__()
        # Load the search glyph (magnifier)
        self._glyph = Image()
        self.add(self._glyph)
        self._glyph.bg_color = (0, 0, 0, 0)
        self._glyph.layout = pgm.IMAGE_SCALED
        self._glyph.alignment = pgm.IMAGE_LEFT
        theme = Theme.get_default()
        glyph = theme.get_resource('elisa.plugins.poblesec.search_glyph')
        self._glyph.set_from_file(glyph)

        def glyph_loaded(image):
            self._glyph.disconnect(self._loaded_id)
            self._glyph.height = 0.4
            real_aspect_ratio = self._glyph.aspect_ratio[0] / float(self._glyph.aspect_ratio[1])
            current_aspect_ratio = self._glyph.absolute_width / self._glyph.absolute_height
            deformation = real_aspect_ratio / current_aspect_ratio
            self._glyph.width *= deformation
            self._glyph.position = (0.02, 0.3, 0.01)
            self._glyph.visible = True
            self._text.width = 0.95 - self._glyph.width
            self._text.x = 0.04 + self._glyph.width

        self._loaded_id = self._glyph.connect('pixbuf-loaded', glyph_loaded)


class EntryBar(Widget):

    def __init__(self):
        super(EntryBar, self).__init__()

        theme = Theme.get_default()

        self.body_normal = Image()
        self.add(self.body_normal)
        self.body_normal.bg_color = (0, 0, 0, 0)
        self.body_normal.layout = pgm.IMAGE_FILLED
        resource = 'elisa.plugins.poblesec.entry_bar_normal'
        self.body_normal.set_from_file(theme.get_resource(resource))
        self.body_normal.size = self.size
        self.body_normal.position = (0.0, 0.0, 0.0)

        self.body_focused = Image()
        self.add(self.body_focused)
        self.body_focused.bg_color = (0, 0, 0, 0)
        self.body_focused.layout = pgm.IMAGE_FILLED
        resource = 'elisa.plugins.poblesec.entry_bar_focused'
        self.body_focused.set_from_file(theme.get_resource(resource))
        self.body_focused.size = self.size
        self.body_focused.position = (0.0, 0.0, 0.0)

        self.highlight(False)

    def highlight(self, highlight):
        """
        Change the background image depending on the focus.

        @param highlight: whether the entry bar should appear highlighted
        @type highlight:  C{bool}
        """
        self.body_normal.visible = not highlight
        self.body_focused.visible = highlight
