# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'

from elisa.base_components.action import Action
from elisa.core import plugin_registry


class GridViewModeAction(Action):
    """
    Change the controller and the view of the manager
    to display items if grid mode
    """

    # FIXME: what is it used for ?
    label='grid mode'
    supported_file_types=()
    
    manager_model = None


    def __call__(self, controller, origin):
        """
        @raise TypeError: When action has incorrect parameters
        """
        ModelClass = plugin_registry.get_component_class('raval:manager_model')
        if isinstance(self.manager_model, ModelClass):
            self.manager_model.current_content_type = 'image'
        else:
            raise TypeError("action %s have incorrect parameters" % self.name)
