# -*- coding: utf-8 -*-
#
#       dontzap.py -- utility to set the DontZap option in xorg.conf
#       
#       Copyright 2008 Alberto Milone <albertomilone@alice.it>
#       
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#       
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#       
#       You should have received a copy of the GNU General Public License
#       along with this program; if not, write to the Free Software
#       Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#       MA 02110-1301, USA.

import os, os.path
from XKit import xutils, xorgparser
import time
import shutil

class DontZap:
    source = '/etc/X11/xorg.conf'
    destination = '/etc/X11/xorg.conf'
    
    targetSection = 'ServerFlags'
    targetOption = 'DontZap'
    
    def isDontZapEnabled(self):
        
        try:
            a = xutils.XUtils(self.source)
        #if xorg.conf is missing or broken
        except(IOError, xorgparser.ParseException):
            # Return True since DontZap is enabled by default in X
            return True
        
        # If the ServerFlags section and/or the DontZap are not
        # available then DontZap is enabled
        try:
            enabledStr = a.getValue(self.targetSection, self.targetOption, 0)
        except xorgparser.SectionException:
            return True
        enabled = not (enabledStr.strip().lower() == 'false')
        
        return enabled
    
    def setDontZap(self, enabled):
        '''Assign the DontZap option a boolean value in xorg.conf'''
        
        source = self.source
        destination = self.destination
        
        targetSection = self.targetSection
        targetOption = self.targetOption
        
        if os.path.exists(source):
            #make a backup of the xorg.conf
            backup = source + "." + time.strftime("%Y%m%d%H%M%S")
            shutil.copyfile(source, backup)
        
        try:
            a = xutils.XUtils(source)
        #if xorg.conf is missing or broken
        except(IOError, xorgparser.ParseException):
            #start from scratch
            a = xutils.XUtils()
        
        empty = True
        for section in a.globaldict:
            if len(a.globaldict[section]) > 0:
                empty = False
                break

        if empty:
            # create a ServerFlags section
            a.makeSection(targetSection)
        
        else:#if xorg.conf exists and is not empty
            
            # if no ServerFlags section exists, create one
            if len(a.globaldict[targetSection]) == 0:
                a.makeSection(targetSection)
            
        # set the option
        a.addOption(targetSection, targetOption, enabled, optiontype='Option')

        '''
        Write the changes to the destination file
        '''
        a.writeFile(destination)
        return True

