;;File: debian-ispell.el
;;Description: Emacsen support for Debian package dictionaries-common
;;Author: Rafael Laboissire <rafael@debian.org>
;;Created on: Tue Oct 26 10:16:12 CEST 1999
;;Last modified on: Wed Nov  3 14:15:37 CET 1999

(defvar debian-ispell-dictionary-alist 
  '((nil "[A-Za-z]" "[^A-Za-z]" "[']" nil ("-B") nil iso-8859-1))
  "Alist of dictionaries used internally by the Debian ispell
initialization scheme.  Its value will be used to set
`ispell-dictionary-alist' after ispell.el is loaded.

Do not change this variable directly.  Use the
`debian-ispell-add-dictionary-entry' function instead.")

(defun debian-ispell-add-dictionary-entry (entry &optional name)
  "Adds an ENTRY to the ispell-dictionary-alist variable. See the 
documentation of the variable ispell-dictionary-alist for the format 
of ENTRY."
  (set-variable 'debian-ispell-dictionary-alist
		(append (list entry) debian-ispell-dictionary-alist)))

;;; -----------------------------------------------------------------------
;;;  Guess default ispell dictionary under emacs and make ispell.el use it
;;; -----------------------------------------------------------------------

(defvar debian-ispell-dictionary 
  "default"
  "The name of the dictionary that will become the default after
loading of ispell.el.")

(defun debian-set-ispell-dictionary ()
  "Set ispell default to the debconf selected one if 
ispell-program-name is ispell."
  (if (not ispell-local-dictionary)
      (if (and (equal ispell-program-name "ispell") debian-ispell-dictionary)
	  (setq ispell-local-dictionary debian-ispell-dictionary)))
  ;; (message "** d-i-c:%s i-l-d:%s" debian-ispell-dictionary ispell-local-dictionary)
  )


;; Load the file containing the default value for debian-ispell-dictionary

(if (file-exists-p "/var/cache/dictionaries-common/emacsen-ispell-default.el")
    (load "/var/cache/dictionaries-common/emacsen-ispell-default.el"))

;;; ---------------------------------------------------------------------------
;;;   Make sure the patched ispell.el is first in the loadpath
;;; ---------------------------------------------------------------------------

(setq load-path
      (append (list (concat "/usr/share/" 
			    (symbol-name debian-emacs-flavor) 
			    "/site-lisp/dictionaries-common"))
	       load-path))

;;; ------------------------------------------------------------------------------
;;; A home made exec-installed-p to test for {i,a}spell executable existence
;;; Implemented here to avoid apel dependency. Will be nulled at the end
;;; ------------------------------------------------------------------------------

(defun debiandc-exec-installed-p (infile)
  "Checking for an executable file in the exec-path. 
Implemented here to avoid apel dependency"
  (let (file paths)
    (setq paths exec-path)
    (catch 'tag
      (while paths
	(setq file (expand-file-name infile (car paths)))
	(if (file-executable-p file)
	    (throw 'tag t)
	  )
	(setq paths (cdr paths))
	)
      )
    )
  )

;; Fallback to aspell if ispell is not present.
;; Will be overriden by ~/.emacs selection if present

(if (not (debiandc-exec-installed-p "ispell"))
    (setq ispell-program-name "aspell"))

(fmakunbound 'debiandc-exec-installed-p)

;;; ----------------------------------------------------------------------------------

;; Local Variables:
;; mode: lisp
;; End:
