/*  Dynamic Host Configuration Client manager D-BUS Daemon  
 *  
 *  Jason Vas Dias <jvdias@redhat.com>, Red Hat Inc., 2005
 */
#include "includes.h"
#include "dhcdbd.h"

void usage(void)
{
    fprintf
    (    stderr,
	 "Usage:\n[\t[(-s | -S | --system)\t\t   : use system bus]\n"
	 "\t[(-u | -U | --session)             : use session bus]\n"
	 "\t[(-n | -N | --no-daemon)]          : don't daemonize if --(system|session) argument given\n"
	 "\t[(-d | -D | --dest=) <destination> : set connection destination - default: com.redhat.dhcp]\n"
	 "\t[(-o | -O | --path=) <path>        : set object path prefix     - default: /com/redhat/dhcp]\n"
	 "\t[(-i | -I | --prefix=) <prefix>    : set interface prefix       - default: com.redhat.dhcp]\n]\n"
    );
}

char 
    dhcdbd_default_dest[]=DHCDBD_DESTINATION, 
    *dhcdbd_destination=&(dhcdbd_default_dest[0]),
    dhcdbd_default_path[]=DHCDBD_OBJECT_PATH,
    *dhcdbd_object_path=&(dhcdbd_default_path[0]),
    dhcdbd_default_prefix[]=DHCDBD_INTERFACE_PREFIX,
    *dhcdbd_interface_prefix=&(dhcdbd_default_prefix[0]);
int dhcdbd_daemonize=-1;

int main( int argc, char **argv, char **envp )
{
    D_BUS_TYPE bus = D_BUS_STARTER;
    char opt_str[] = "UuSsnND:d:O:o:P:p:I:i:", arg;
    struct option options[] =
    {
	{ "session",0, 0, 'u' },
	{ "system", 0, 0, 's' },
	{ "no-daemon", 0, 0, 'n' },
	{ "dest",   1, 0, 'd' },
	{ "path",   1, 0, 'o' },
	{ "prefix", 1, 0, 'i' },
	{ 0L,       0, 0,  0  }
    };
    int r;
    if ( argc > 1 )
	while( ((r = getopt_long( argc, argv, opt_str, &(options[0]), 0L )) != -1) 
	     &&((arg = r) != '\0')
	     )
	    switch(arg)
	    {
	    case '?':
		fprintf(stderr,"Missing option argument.\n");
		usage();
		return(1);
	    case ':':
		fprintf(stderr,"Unrecognized option.\n");
		usage();
		return(1);
	    case 'u':
	    case 'U':
		bus = D_BUS_SESSION;
		if (dhcdbd_daemonize == -1)
		    dhcdbd_daemonize=1;
		break;
	    case 's':
	    case 'S':
		bus = D_BUS_SYSTEM;
		if (dhcdbd_daemonize == -1)
		    dhcdbd_daemonize=1;
		break;
	    case 'n':
		dhcdbd_daemonize=0;
		break;
	    case 'd':
	    case 'D':
		if( optarg == 0L )
		{
		    fprintf(stderr,"Missing argument for -d destination option.\n");
		    usage();
		    return(1);
		}
		if((dhcdbd_destination = (char*)malloc(strlen(optarg)+1))==0L)
		{
		    fprintf(stderr,"out of memory\n");
		    return(1);
		}	       
		strcpy(dhcdbd_destination,optarg);
		break;
	    case 'o':
	    case 'O':
	    case 'p':
	    case 'P':
		if( optarg == 0L )
		{
		    fprintf(stderr,"Missing argument for -o object path option.\n");
		    usage();
		    return(1);
		}
		if((dhcdbd_object_path = (char*)malloc(strlen(optarg)+1))==0L)
		{
		    fprintf(stderr,"out of memory\n");
		    return(1);
		}	       
		strcpy(dhcdbd_object_path,optarg);
		break;
	    case 'i':
	    case 'I':
		if( optarg == 0L )
		{
		    fprintf(stderr,"Missing argument for -i interface prefix option.\n");
		    usage();
		    return(1);
		}
		if((dhcdbd_interface_prefix = (char*)malloc(strlen(optarg)+1))==0L)
		{
		    fprintf(stderr,"out of memory\n");
		    return(1);
		}	       
		strcpy(dhcdbd_interface_prefix,optarg);
		break;
	     
	    default:
		fprintf(stderr,"Unhandled getopt_long return value: %d\n", r) ;
		return(1);
	    }
    if( dhcdbd_daemonize == -1 )
	dhcdbd_daemonize = 0;
    return dhcdbd_run( bus );
}
