#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of 
# the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Copyright 2007-2008 Martin Böhm <martin.bohm@kubuntu.org>
# Copyright 2007-2008 Michael Anderson <nosrednaekim@gmail.com>

import sys
import os
from optparse import OptionParser
from PyQt4.QtGui import *
from PyQt4.QtCore import *
from PyQt4.QtSvg import *

from DesktopEffectsQt4Dialog import Ui_Dialog
from DesktopEffectsCommon import DesktopEffectsCommon
import gettext

def _(str):
    ''' the traditional gettext function '''
    return unicode(gettext.gettext(str), 'UTF-8')

def __(catalog,str):
    ''' selects a different catalog for the str translation;
        useful when you want to use the standard KDE labels. '''
    return unicode(gettext.dgettext(catalog, str), 'UTF-8')

def utf8(str):
  if isinstance(str, unicode):
      return str
  return unicode(str, 'UTF-8')

class DesktopEffectsKDE4(DesktopEffectsCommon):
    def __init__(self):
        '''launches the app, draws the window '''
        # needed for all Qt actions 
        app = QApplication (sys.argv)

        # Qt4 explanations:
        # self.qd is the link to the main QDialog (what you can see)
        # self.ui is its UI (the UI defined in Qt-Designer
        self.qd = QDialog()
        self.ui = Ui_Dialog()
        self.ui.setupUi(self.qd)

        localesApp="desktop-effects-kde"
        localesDir="/usr/share/locale"
        gettext.bindtextdomain(localesApp, localesDir)
        gettext.textdomain(localesApp)

        # the Common class triggers some UI text settings, so we need to 
        # init the UI first
        DesktopEffectsCommon.__init__(self)
	   
        self.radioGroup = QButtonGroup(self.qd)
        self.radioGroup.setExclusive(True)
        self.radioGroup.addButton(self.ui.noEffectsButton)
        self.radioGroup.addButton(self.ui.stdEffectsButton)
        self.radioGroup.addButton(self.ui.extraEffectsButton)
        self.radioGroup.addButton(self.ui.customEffectsButton)
	   
        # connect signals and slots -- we have to do it ourselves in Qt4
        QObject.connect(self.ui.installButton, SIGNAL("clicked()"), self.btnInstallClicked)
        QObject.connect(self.ui.done, SIGNAL("clicked()"), self.done)
        QObject.connect(self.ui.apply, SIGNAL("clicked()"), self.apply)	   
        # connect radio buttons - methods provided by the Common class
        QObject.connect(self.ui.noEffectsButton,     SIGNAL("clicked()"), self.noEffects)
        QObject.connect(self.ui.stdEffectsButton,    SIGNAL("clicked()"), self.standardEffects)
        QObject.connect(self.ui.extraEffectsButton,  SIGNAL("clicked()"), self.extraEffects)
        QObject.connect(self.ui.customEffectsButton, SIGNAL("clicked()"), self.customEffects)

        #self.ui.installButton.setText(_("Install"))
        self.ui.warningText.setText(_("Desktop Effects are an experimental feature of Kubuntu and are not officially supported."))
        self.ui.groupBox.setTitle(_("Effects Level"))
        self.ui.noEffectsButton.setText(_("No Effects"))
        self.ui.label_6.setText(_("All effects are disabled and KDE Window manager is used. This is the default behaviour."))
        self.ui.stdEffectsButton.setText(_("Standard Effects"))
        self.ui.label_12.setText(_("Some simple effects."))
        self.ui.extraEffectsButton.setText(_("Extra Effects"))
        self.ui.label_14.setText(_("You\'ll need sunglasses"))
        self.ui.customEffectsButton.setText(_("Custom Effects"))
        self.ui.label_16.setText(_("Use custom settings from another settings manager. Switching from this option to another will back up any custom settings"))
        self.ui.apply.setText(_("Apply"))
        self.ui.done.setText(_("Done"))
        self.qd.show()
        sys.exit(self.qd.exec_())
	   
    def check(self):
        ''' overrides the DesktopEffectsCommon.check() method, does some painting '''
        DesktopEffectsCommon.check(self)
        self.ui.packageText.setText(self.pText)
        self.ui.installButton.setText(self.ibText)
        if os.path.exists(os.path.expanduser("~/.kde/share/config/compizasWM")):
		   compizasWM = open(os.path.expanduser("~/.kde/share/config/compizasWM"))
		   state = compizasWM.readline()
		   if state == "standardeffects":
			   self.action = 2
			   self.ui.stdEffectsButton.toggle()
		   elif state == "extraeffects":
			   self.action = 3
			   self.ui.extraEffectsButton.toggle()
		   elif state == "custom":
			   self.action = 4
			   self.ui.customEffectsButton.toggle()	   	   
        else:                                             
		   self.action = 1
		   self.ui.noEffectsButton.toggle()
    def apply(self):
         DesktopEffectsCommon.apply(self)
         if self.action == 1:
		   print "hi"
		   os.popen("kwin --replace &")

    def showWarning(self):
        ''' shows the warning box if the package is installed '''
        self.ui.warningText.show()
        self.ui.warningIcon.show()

    def hideWarning(self):
        ''' hides the warning because the package is not yet there '''
        self.ui.warningText.hide()
        self.ui.warningIcon.hide()

    def enable(self):
        ''' enables the radio boxes, compiz is installed '''
        self.ui.groupBox.setDisabled(False)

    def disable(self):
        ''' disables the group box, you have to install compiz first '''
        self.ui.groupBox.setDisabled(True)

    def close(self):
        ''' triggers the QDialog to close '''
        self.qd.close()
