/*
 * This is a helper library to ease testing of D-Bus objects.
 * Copyright (C) 2008 by Tobias Hunger <tobias@aquazul.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "decibeltestcase.h"
#include "config.h"

#include <Decibel/Types>

#include <QtCore/qglobal.h>

// ---------------------------------------------------------------------------
// DecibelTestCase implementation:
// ---------------------------------------------------------------------------

DecibelTestCase::DecibelTestCase(QObject * parent) :
    DBusTestCase(true, parent)
{ }


DecibelTestCase::~DecibelTestCase()
{ }

void DecibelTestCase::initTestCase()
{
    DBusTestCase::initTestCase();
    startDecibel();
}

void DecibelTestCase::startDecibel()
{
    // change home environment variable so that decibel
    // will pick up its configuration data from a "save"
    // place during the tests.
    qputenv("HOME", TEST_HOME_PATH);
    startAUT("../../src/server/decibel");

    // Register types we are going to use:
    Decibel::registerTypes();

    // Give decibel a chance to start up properly:
    QTest::qWait(5000);
}
