#!/bin/sh
#
# hotplug-misc.sh - Handle hotplug events for non-PCMCIA devices
#

log () {
	logger -t hotplug-misc "$@"
}

TYPE="$1"

case $TYPE in
	firmware)
		if [ "$ACTION" != add ]; then
			log "Firmware '$ACTION' event not supported"
			exit 1
		fi

		FIRMWARE_DIRS='/lib/hotplug/firmware /usr/lib/hotplug/firmware'
		SYSFS="$(sed -n 's/^.* \([^ ]*\) sysfs .*$/\1/p' /proc/mounts)"
		VERSION="$(uname -r)"
		# use /proc for 2.4 kernels
		if [ -z "$SYSFS" ]; then
			SYSFS=/proc
		fi

		if [ ! -e "$SYSFS/$DEVPATH/loading" ]; then
			sleep 1
		fi

		FIRMWARE_FOUND=
		for DIR in $FIRMWARE_DIRS; do
			if [ -e "$DIR/$FIRMWARE-$VERSION" ]; then
				FIRMWARE_FOUND="$DIR/$FIRMWARE-$VERSION"
				break
			elif [ -e "$DIR/$FIRMWARE" ]; then
				FIRMWARE_FOUND="$DIR/$FIRMWARE"
				break
			fi
		done

		if [ "$FIRMWARE_FOUND" ]; then
			echo 1 > "$SYSFS/$DEVPATH/loading"
			cat "$FIRMWARE_FOUND" > "$SYSFS/$DEVPATH/data"
			echo 0 > "$SYSFS/$DEVPATH/loading"
			log "Firmware for $FIRMWARE loaded successfully."
		else
			echo -1 > "$SYSFS/$DEVPATH/loading"
			log "No firmware found for $FIRMWARE."
		fi
	;;

	*)
		log "Got unsupported event type \"$TYPE\""
	;;
esac
