<?xml version='1.0'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version='1.0'>

<!--############################################################################
    XSLT Stylesheet DocBook -> LaTeX 
    ############################################################################ -->

<xsl:variable name="latex.use.hyperref">0</xsl:variable>
<xsl:param name="doc.section.depth">5</xsl:param>
<xsl:param name="toc.section.depth">5</xsl:param>
<xsl:param name="doc.pdfcreator.show">1</xsl:param>
<xsl:param name="doc.publisher.show">0</xsl:param>
<xsl:param name="doc.collab.show">1</xsl:param>
<xsl:param name="doc.alignment"/>
<xsl:param name="set.book.num">1</xsl:param>
<xsl:param name="draft.mode">no</xsl:param>


<xsl:variable name="latex.begindocument">
  <xsl:text>\begin{document}&#10;</xsl:text>
</xsl:variable>

<xsl:variable name="latex.enddocument">
  <xsl:text>&#10;\end{document}&#10;</xsl:text>
</xsl:variable>


<xsl:template match="book|article" mode="preamble">
  <xsl:param name="lang"/>
  <xsl:variable name="info" select="bookinfo|articleinfo|artheader|info"/>

  <xsl:text>% -----------------------------------------  &#10;</xsl:text>
  <xsl:text>% Autogenerated LaTeX file from XML DocBook  &#10;</xsl:text>
  <xsl:text>% -----------------------------------------  &#10;</xsl:text>
  <!-- Parameters to pass to python parser -->
  <xsl:call-template name="py.params.set"/>
  <xsl:text>\documentclass</xsl:text>
  <xsl:if test="$latex.class.options!=''">
    <xsl:value-of select="concat('[',$latex.class.options,']')"/>
  </xsl:if>
  <xsl:text>{</xsl:text>
  <xsl:choose>
    <xsl:when test="self::book">
      <xsl:value-of select="$latex.class.book"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$latex.class.article"/>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:text>}&#10;</xsl:text>
  
  <xsl:call-template name="encode.before.style">
    <xsl:with-param name="lang" select="$lang"/>
  </xsl:call-template>
  <xsl:text>\usepackage{fancybox}&#10;</xsl:text>
  <xsl:text>\usepackage{makeidx}&#10;</xsl:text>

  <xsl:call-template name="user.params.set"/>

  <!-- Load babel before the style (bug #babel/3875) -->
  <xsl:call-template name="babel.setup"/>
  <xsl:text>\usepackage[hyperlink]{</xsl:text>
  <xsl:value-of select="$latex.style"/>
  <xsl:text>}&#10;</xsl:text>

  <xsl:call-template name="encode.after.style">
    <xsl:with-param name="lang" select="$lang"/>
  </xsl:call-template>
  <xsl:call-template name="lang.setup"/>
  <xsl:call-template name="citation.setup"/>
  <xsl:call-template name="biblio.setup"/>
  <xsl:call-template name="annotation.setup"/>
  <xsl:call-template name="user.params.set2"/>
  <xsl:apply-templates select="." mode="docinfo"/>

  <!-- Document title -->
  <xsl:text>\title{</xsl:text>
    <xsl:call-template name="normalize-scape">
      <xsl:with-param name="string">
        <xsl:choose>
        <xsl:when test="title">
          <xsl:value-of select="title"/>
        </xsl:when>
        <xsl:when test="$info">
          <xsl:value-of select="$info/title"/>
        </xsl:when>
        </xsl:choose>
      </xsl:with-param>
    </xsl:call-template>
  <xsl:text>}&#10;</xsl:text>

  <!-- Get the Authors -->
  <xsl:variable name="authors">
    <xsl:choose>
      <xsl:when test="$info and $info/authorgroup/author">
        <xsl:apply-templates select="$info/authorgroup"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="$info/author"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:text>\author{</xsl:text>
  <xsl:value-of select="$authors"/>
  <xsl:text>}&#10;</xsl:text>

  <!-- Set the collaborator table -->
  <xsl:call-template name="collab.setup">
    <xsl:with-param name="authors" select="$authors"/>
  </xsl:call-template>

  <xsl:text>\makeindex&#10;</xsl:text>
  <xsl:text>\makeglossary&#10;</xsl:text>

  <!-- Apply the revision history here -->
  <xsl:apply-templates select="$info/revhistory"/>
</xsl:template>

<!-- ##################################
     # Preamble setup from parameters #
     ################################## -->

<!-- Setup from the user parameters -->
<xsl:template name="user.params.set">
  <xsl:if test="$latex.hyperparam!=''">
    <xsl:text>\def\hyperparam{</xsl:text>
    <xsl:value-of select="$latex.hyperparam"/>
    <xsl:text>}&#10;</xsl:text>
  </xsl:if>
  <xsl:if test="$doc.pdfcreator.show='1'">
    <xsl:text>\def\hyperparamadd{</xsl:text>
    <xsl:text>pdfcreator=DBLaTeX-</xsl:text>
    <xsl:value-of select="$version"/>
    <xsl:text>}&#10;</xsl:text>
  </xsl:if>
  <xsl:if test="$doc.publisher.show='1'">
    <xsl:text>\def\DBKpublisher{</xsl:text>
    <xsl:text>\includegraphics{dblatex}</xsl:text>
    <xsl:text>}&#10;</xsl:text>
  </xsl:if>
  <xsl:if test="$literal.layout.options">
    <xsl:text>\def\lstparamset{\lstset{</xsl:text>
    <xsl:value-of select="$literal.layout.options"/>
    <xsl:text>}}&#10;</xsl:text>
  </xsl:if>
  <xsl:if test="$doc.alignment!='' and $doc.alignment!='justify'">
    <xsl:text>\usepackage{ragged2e}&#10;</xsl:text>
    <xsl:choose>
    <xsl:when test="$doc.alignment='center'">
      <xsl:text>\Centering&#10;</xsl:text>
    </xsl:when>
    <xsl:when test="$doc.alignment='left'">
      <xsl:text>\RaggedRight&#10;</xsl:text>
    </xsl:when>
    <xsl:when test="$doc.alignment='right'">
      <xsl:text>\RaggedLeft&#10;</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:message>Unknown doc.alignment='<xsl:value-of
      select="$doc.alignment"/>'</xsl:message>
    </xsl:otherwise>
    </xsl:choose>
  </xsl:if>
</xsl:template>

<!-- Setup to do when the docbook package is loaded -->
<xsl:template name="user.params.set2">
  <xsl:if test="$pdf.annot.options">
    <xsl:text>\commentsetup{</xsl:text>
    <xsl:value-of select="$pdf.annot.options"/>
    <xsl:text>}&#10;</xsl:text>
  </xsl:if>
  <xsl:if test="$draft.mode='no'">
    <xsl:text>\renewcommand{\DBKreleaseinfo}{}&#10;</xsl:text>
  </xsl:if>
  <xsl:if test="$latex.output.revhistory=0">
    <xsl:text>\renewcommand{\DBKrevhistory}{}&#10;</xsl:text>
  </xsl:if>
  <xsl:text>\setcounter{tocdepth}{</xsl:text>
  <xsl:value-of select="$toc.section.depth"/>
  <xsl:text>}&#10;</xsl:text>
  <xsl:text>\setcounter{secnumdepth}{</xsl:text>
  <xsl:value-of select="$doc.section.depth"/>
  <xsl:text>}&#10;</xsl:text>
</xsl:template>

<!-- #################
     # Collaborators #
     ################# -->

<xsl:template name="collab.setup">
  <xsl:param name="authors"/>
  <xsl:if test="$doc.collab.show!='0'">
    <xsl:text>% ------------------
% Collaborators
% ------------------
\renewcommand{\DBKindexation}{
\begin{DBKindtable}
\DBKinditem{\writtenby}{</xsl:text>
    <xsl:value-of select="$authors"/>
    <xsl:text>}</xsl:text>
    <xsl:apply-templates select=".//othercredit"/>
    <xsl:text>&#10;\end{DBKindtable}&#10;}&#10;</xsl:text>
  </xsl:if>
</xsl:template>

<xsl:template match="othercredit">
  <xsl:text>\DBKinditem{</xsl:text>
  <xsl:value-of select="contrib"/>
  <xsl:text>}{</xsl:text>
  <xsl:apply-templates select="firstname"/>
  <xsl:text> </xsl:text>
  <xsl:apply-templates select="surname"/>
  <xsl:text>}&#10;</xsl:text>
</xsl:template>

<!-- ########################
     # Document infos setup #
     ######################## -->

<xsl:template match="book|article" mode="docinfo">
  <xsl:apply-templates select="bookinfo|articleinfo|info" mode="docinfo"/>

  <!-- Override the infos if specified in the root element -->
  <xsl:apply-templates select="subtitle" mode="docinfo"/>
</xsl:template>

<xsl:template match="bookinfo|articleinfo|info" mode="docinfo">
  <!-- special case for copyrights, managed as a group -->
  <xsl:if test="copyright">
    <xsl:text>\renewcommand{\DBKcopyright}{</xsl:text>
    <xsl:apply-templates select="copyright" mode="titlepage.mode"/>
    <xsl:text>}&#10;</xsl:text>
  </xsl:if>
  <xsl:apply-templates mode="docinfo"/>
</xsl:template>

<xsl:template match="*" mode="docinfo"/>

<xsl:template match="address" mode="docinfo">
  <xsl:text>\renewcommand{\DBKsite}{</xsl:text>
  <xsl:value-of select="normalize-space(.)"/>
  <xsl:text>}&#10;</xsl:text>
</xsl:template>

<xsl:template match="releaseinfo" mode="docinfo">
  <xsl:if test="$draft.mode!='no'">
    <xsl:text>\renewcommand{\DBKreleaseinfo}{</xsl:text>
    <xsl:apply-templates select="."/>
    <xsl:text>}&#10;</xsl:text>
  </xsl:if>
</xsl:template>

<xsl:template match="pubdate" mode="docinfo">
  <xsl:text>\renewcommand{\DBKpubdate}{</xsl:text>
  <xsl:value-of select="normalize-space(.)"/>
  <xsl:text>}&#10;</xsl:text>
</xsl:template>

<xsl:template match="pubsnumber" mode="docinfo">
  <xsl:text>\renewcommand{\DBKreference}{</xsl:text>
  <xsl:value-of select="normalize-space(.)"/>
  <xsl:text>}&#10;</xsl:text>
</xsl:template>

<xsl:template match="edition" mode="docinfo">
  <xsl:text>\renewcommand{\DBKedition}{</xsl:text>
  <xsl:call-template name="normalize-scape">
    <xsl:with-param name="string" select="."/>
  </xsl:call-template>
  <xsl:text>}&#10;</xsl:text>
</xsl:template>

<xsl:template match="date" mode="docinfo">
  <!-- Override the date definition if specified -->
  <xsl:text>\renewcommand{\DBKdate}{</xsl:text>
  <xsl:value-of select="normalize-space(.)"/>
  <xsl:text>}&#10;</xsl:text>
</xsl:template>

<xsl:template match="subtitle" mode="docinfo">
  <xsl:text>\renewcommand{\DBKsubtitle}{</xsl:text>
  <xsl:call-template name="normalize-scape">
    <xsl:with-param name="string" select="."/>
  </xsl:call-template>
  <xsl:text>}&#10;</xsl:text>
</xsl:template>

<xsl:template match="releaseinfo">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="holder" mode="titlepage.mode">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="copyright" mode="titlepage.mode">
  <xsl:text>\noindent </xsl:text>
  <xsl:call-template name="gentext">
    <xsl:with-param name="key" select="'Copyright'"/>
  </xsl:call-template>
  <xsl:call-template name="gentext.space"/>
  <xsl:call-template name="dingbat">
    <xsl:with-param name="dingbat">copyright</xsl:with-param>
  </xsl:call-template>
  <xsl:call-template name="gentext.space"/>
  <xsl:call-template name="copyright.years">
    <xsl:with-param name="years" select="year"/>
    <xsl:with-param name="print.ranges" select="$make.year.ranges"/>
    <xsl:with-param name="single.year.ranges"
                    select="$make.single.year.ranges"/>
  </xsl:call-template>
  <xsl:call-template name="gentext.space"/>
  <xsl:apply-templates select="holder" mode="titlepage.mode"/>
  <xsl:if test="following-sibling::copyright">
    <xsl:text>\par&#10;</xsl:text>
  </xsl:if>
</xsl:template>

<!-- #################
     # Main template #
     ################# -->

<xsl:template match="book|article">
  <xsl:variable name="info" select="bookinfo|articleinfo|artheader|info"/>
  <xsl:variable name="lang">
    <xsl:call-template name="l10n.language">
      <xsl:with-param name="target" select="(/set|/book|/article)[1]"/>
      <xsl:with-param name="xref-context" select="true()"/>
    </xsl:call-template>
  </xsl:variable>

  <!-- Latex preamble -->
  <xsl:apply-templates select="." mode="preamble">
    <xsl:with-param name="lang" select="$lang"/>
  </xsl:apply-templates>

  <xsl:value-of select="$latex.begindocument"/>
  <xsl:call-template name="lang.document.begin">
    <xsl:with-param name="lang" select="$lang"/>
  </xsl:call-template>

  <!-- Apply the legalnotices here, when language is active -->
  <xsl:call-template name="print.legalnotice">
    <xsl:with-param name="nodes" select="$info/legalnotice"/>
  </xsl:call-template>

  <xsl:text>\maketitle&#10;</xsl:text>

  <!-- Print the TOC/LOTs -->
  <xsl:apply-templates select="." mode="toc_lots"/>
  <xsl:call-template name="label.id"/>

  <!-- Print the abstract -->
  <xsl:apply-templates select="(abstract|$info/abstract)[1]"/>

  <!-- Body content -->
  <xsl:apply-templates select="*[not(self::abstract)]"/>
  <xsl:if test="*//indexterm|*//keyword">
    <xsl:text>\printindex&#10;</xsl:text>
  </xsl:if>
  <xsl:call-template name="lang.document.end">
    <xsl:with-param name="lang" select="$lang"/>
  </xsl:call-template>
  <xsl:value-of select="$latex.enddocument"/>
</xsl:template>

<xsl:template match="book/title"/>
<xsl:template match="article/title"/>
<xsl:template match="bookinfo"/>
<xsl:template match="articleinfo"/>

<!-- ################
     # Set of books #
     ################ -->

<!-- Only one book from the set is printed -->
<xsl:template match="set">
  <xsl:message>
    <xsl:text>Warning: only print the book [</xsl:text>
    <xsl:value-of select="$set.book.num"/>
    <xsl:text>]</xsl:text>
  </xsl:message>
  <xsl:apply-templates select="//book[position()=$set.book.num]"/>
</xsl:template>

<xsl:template match="set/setinfo"></xsl:template>
<xsl:template match="set/title"></xsl:template>
<xsl:template match="set/subtitle"></xsl:template>

</xsl:stylesheet>
