/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "3d_options.h"

static int TdOptionsDisplayPrivateIndex;

static CompMetadata tdOptionsMetadata;

static CompPluginVTable *tdPluginVTable = NULL;
CompPluginVTable tdOptionsVTable;

#define TD_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, TdOptions, o)
#define TD_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, TdOptions, o)

typedef struct _TdOptionsDisplay
{
    int screenPrivateIndex;

} TdOptionsDisplay;

typedef struct _TdOptionsScreen
{
    CompOption opt[TdScreenOptionNum];
    tdScreenOptionChangeNotifyProc notify[TdScreenOptionNum];
} TdOptionsScreen;

CompMatch * tdGetWindowMatch (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return &os->opt[TdScreenOptionWindowMatch].value.match;
}

CompOption * tdGetWindowMatchOption (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return &os->opt[TdScreenOptionWindowMatch];
}

void tdSetWindowMatchNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify)
{
    TD_OPTIONS_SCREEN(s);
    os->notify[TdScreenOptionWindowMatch] = notify;
}

int tdGetMinCubeSize (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return os->opt[TdScreenOptionMinCubeSize].value.i;
}

CompOption * tdGetMinCubeSizeOption (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return &os->opt[TdScreenOptionMinCubeSize];
}

void tdSetMinCubeSizeNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify)
{
    TD_OPTIONS_SCREEN(s);
    os->notify[TdScreenOptionMinCubeSize] = notify;
}

int tdGetMaxWindowSpace (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return os->opt[TdScreenOptionMaxWindowSpace].value.i;
}

CompOption * tdGetMaxWindowSpaceOption (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return &os->opt[TdScreenOptionMaxWindowSpace];
}

void tdSetMaxWindowSpaceNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify)
{
    TD_OPTIONS_SCREEN(s);
    os->notify[TdScreenOptionMaxWindowSpace] = notify;
}

float tdGetSpeed (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return os->opt[TdScreenOptionSpeed].value.f;
}

CompOption * tdGetSpeedOption (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return &os->opt[TdScreenOptionSpeed];
}

void tdSetSpeedNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify)
{
    TD_OPTIONS_SCREEN(s);
    os->notify[TdScreenOptionSpeed] = notify;
}

Bool tdGetManualOnly (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return os->opt[TdScreenOptionManualOnly].value.b;
}

CompOption * tdGetManualOnlyOption (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return &os->opt[TdScreenOptionManualOnly];
}

void tdSetManualOnlyNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify)
{
    TD_OPTIONS_SCREEN(s);
    os->notify[TdScreenOptionManualOnly] = notify;
}

float tdGetWidth (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return os->opt[TdScreenOptionWidth].value.f;
}

CompOption * tdGetWidthOption (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return &os->opt[TdScreenOptionWidth];
}

void tdSetWidthNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify)
{
    TD_OPTIONS_SCREEN(s);
    os->notify[TdScreenOptionWidth] = notify;
}

int tdGetBevel (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return os->opt[TdScreenOptionBevel].value.i;
}

CompOption * tdGetBevelOption (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return &os->opt[TdScreenOptionBevel];
}

void tdSetBevelNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify)
{
    TD_OPTIONS_SCREEN(s);
    os->notify[TdScreenOptionBevel] = notify;
}

unsigned short * tdGetWidthColor (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return os->opt[TdScreenOptionWidthColor].value.c;
}

unsigned short tdGetWidthColorRed (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return os->opt[TdScreenOptionWidthColor].value.c[0];
}

unsigned short tdGetWidthColorGreen (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return os->opt[TdScreenOptionWidthColor].value.c[1];
}

unsigned short tdGetWidthColorBlue (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return os->opt[TdScreenOptionWidthColor].value.c[2];
}

unsigned short tdGetWidthColorAlpha (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return os->opt[TdScreenOptionWidthColor].value.c[3];
}

CompOption * tdGetWidthColorOption (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return &os->opt[TdScreenOptionWidthColor];
}

void tdSetWidthColorNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify)
{
    TD_OPTIONS_SCREEN(s);
    os->notify[TdScreenOptionWidthColor] = notify;
}

unsigned short * tdGetWidthColorInactive (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return os->opt[TdScreenOptionWidthColorInactive].value.c;
}

unsigned short tdGetWidthColorInactiveRed (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return os->opt[TdScreenOptionWidthColorInactive].value.c[0];
}

unsigned short tdGetWidthColorInactiveGreen (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return os->opt[TdScreenOptionWidthColorInactive].value.c[1];
}

unsigned short tdGetWidthColorInactiveBlue (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return os->opt[TdScreenOptionWidthColorInactive].value.c[2];
}

unsigned short tdGetWidthColorInactiveAlpha (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return os->opt[TdScreenOptionWidthColorInactive].value.c[3];
}

CompOption * tdGetWidthColorInactiveOption (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return &os->opt[TdScreenOptionWidthColorInactive];
}

void tdSetWidthColorInactiveNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify)
{
    TD_OPTIONS_SCREEN(s);
    os->notify[TdScreenOptionWidthColorInactive] = notify;
}

Bool tdGetBevelTopleft (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return os->opt[TdScreenOptionBevelTopleft].value.b;
}

CompOption * tdGetBevelTopleftOption (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return &os->opt[TdScreenOptionBevelTopleft];
}

void tdSetBevelTopleftNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify)
{
    TD_OPTIONS_SCREEN(s);
    os->notify[TdScreenOptionBevelTopleft] = notify;
}

Bool tdGetBevelTopright (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return os->opt[TdScreenOptionBevelTopright].value.b;
}

CompOption * tdGetBevelToprightOption (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return &os->opt[TdScreenOptionBevelTopright];
}

void tdSetBevelToprightNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify)
{
    TD_OPTIONS_SCREEN(s);
    os->notify[TdScreenOptionBevelTopright] = notify;
}

Bool tdGetBevelBottomleft (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return os->opt[TdScreenOptionBevelBottomleft].value.b;
}

CompOption * tdGetBevelBottomleftOption (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return &os->opt[TdScreenOptionBevelBottomleft];
}

void tdSetBevelBottomleftNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify)
{
    TD_OPTIONS_SCREEN(s);
    os->notify[TdScreenOptionBevelBottomleft] = notify;
}

Bool tdGetBevelBottomright (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return os->opt[TdScreenOptionBevelBottomright].value.b;
}

CompOption * tdGetBevelBottomrightOption (CompScreen *s)
{
    TD_OPTIONS_SCREEN(s);
    return &os->opt[TdScreenOptionBevelBottomright];
}

void tdSetBevelBottomrightNotify (CompScreen *s, tdScreenOptionChangeNotifyProc notify)
{
    TD_OPTIONS_SCREEN(s);
    os->notify[TdScreenOptionBevelBottomright] = notify;
}

CompOption * tdGetScreenOption (CompScreen *s, TdScreenOptions num)
{
    TD_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo tdOptionsScreenOptionInfo[] = {
    { "window_match", "match", 0, 0, 0 },
    { "min_cube_size", "int", "<min>10</min><max>100</max>", 0, 0 },
    { "max_window_space", "int", "<min>0</min><max>50</max>", 0, 0 },
    { "speed", "float", "<min>0.0</min><max>1.0</max>", 0, 0 },
    { "manual_only", "bool", 0, 0, 0 },
    { "width", "float", "<min>0.0</min><max>1.0</max>", 0, 0 },
    { "bevel", "int", "<min>0</min><max>20</max>", 0, 0 },
    { "width_color", "color", 0, 0, 0 },
    { "width_color_inactive", "color", 0, 0, 0 },
    { "bevel_topleft", "bool", 0, 0, 0 },
    { "bevel_topright", "bool", 0, 0, 0 },
    { "bevel_bottomleft", "bool", 0, 0, 0 },
    { "bevel_bottomright", "bool", 0, 0, 0 },
};

static Bool tdOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, const char *name, CompOptionValue *value)
{
    TD_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, TdScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case TdScreenOptionWindowMatch:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[TdScreenOptionWindowMatch])
                (*os->notify[TdScreenOptionWindowMatch]) (s, o, TdScreenOptionWindowMatch);
            return TRUE;
        }
        break;
     case TdScreenOptionMinCubeSize:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[TdScreenOptionMinCubeSize])
                (*os->notify[TdScreenOptionMinCubeSize]) (s, o, TdScreenOptionMinCubeSize);
            return TRUE;
        }
        break;
     case TdScreenOptionMaxWindowSpace:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[TdScreenOptionMaxWindowSpace])
                (*os->notify[TdScreenOptionMaxWindowSpace]) (s, o, TdScreenOptionMaxWindowSpace);
            return TRUE;
        }
        break;
     case TdScreenOptionSpeed:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[TdScreenOptionSpeed])
                (*os->notify[TdScreenOptionSpeed]) (s, o, TdScreenOptionSpeed);
            return TRUE;
        }
        break;
     case TdScreenOptionManualOnly:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[TdScreenOptionManualOnly])
                (*os->notify[TdScreenOptionManualOnly]) (s, o, TdScreenOptionManualOnly);
            return TRUE;
        }
        break;
     case TdScreenOptionWidth:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[TdScreenOptionWidth])
                (*os->notify[TdScreenOptionWidth]) (s, o, TdScreenOptionWidth);
            return TRUE;
        }
        break;
     case TdScreenOptionBevel:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[TdScreenOptionBevel])
                (*os->notify[TdScreenOptionBevel]) (s, o, TdScreenOptionBevel);
            return TRUE;
        }
        break;
     case TdScreenOptionWidthColor:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[TdScreenOptionWidthColor])
                (*os->notify[TdScreenOptionWidthColor]) (s, o, TdScreenOptionWidthColor);
            return TRUE;
        }
        break;
     case TdScreenOptionWidthColorInactive:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[TdScreenOptionWidthColorInactive])
                (*os->notify[TdScreenOptionWidthColorInactive]) (s, o, TdScreenOptionWidthColorInactive);
            return TRUE;
        }
        break;
     case TdScreenOptionBevelTopleft:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[TdScreenOptionBevelTopleft])
                (*os->notify[TdScreenOptionBevelTopleft]) (s, o, TdScreenOptionBevelTopleft);
            return TRUE;
        }
        break;
     case TdScreenOptionBevelTopright:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[TdScreenOptionBevelTopright])
                (*os->notify[TdScreenOptionBevelTopright]) (s, o, TdScreenOptionBevelTopright);
            return TRUE;
        }
        break;
     case TdScreenOptionBevelBottomleft:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[TdScreenOptionBevelBottomleft])
                (*os->notify[TdScreenOptionBevelBottomleft]) (s, o, TdScreenOptionBevelBottomleft);
            return TRUE;
        }
        break;
     case TdScreenOptionBevelBottomright:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[TdScreenOptionBevelBottomright])
                (*os->notify[TdScreenOptionBevelBottomright]) (s, o, TdScreenOptionBevelBottomright);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * tdOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    TD_OPTIONS_SCREEN(s);
    *count = TdScreenOptionNum;
    return os->opt;
}

static Bool tdOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    TdOptionsScreen *os;
    
    TD_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(TdOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &tdOptionsMetadata, tdOptionsScreenOptionInfo, os->opt, TdScreenOptionNum))
    {
        free (os);
        return FALSE;
    }

    return TRUE;
}

static void tdOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    TD_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, TdScreenOptionNum);

    free (os);
}

static Bool tdOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    TdOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(TdOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[TdOptionsDisplayPrivateIndex].ptr = od;

    
    return TRUE;
}

static void tdOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    TD_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);
    free (od);
}

static Bool tdOptionsInit (CompPlugin *p)
{
    TdOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (TdOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&tdOptionsMetadata, "3d",0, 0, tdOptionsScreenOptionInfo, TdScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&tdOptionsMetadata, "3d");
    if (tdPluginVTable && tdPluginVTable->init)
        return tdPluginVTable->init (p);
    return TRUE;
}

static void tdOptionsFini (CompPlugin *p)
{
    if (tdPluginVTable && tdPluginVTable->fini)
        tdPluginVTable->fini (p);

    if (TdOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (TdOptionsDisplayPrivateIndex);

    compFiniMetadata (&tdOptionsMetadata);
}

static CompBool tdOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) tdOptionsInitDisplay,
        (InitPluginObjectProc) tdOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void tdOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) tdOptionsFiniDisplay,
        (FiniPluginObjectProc) tdOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool tdOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = tdOptionsInitObject (p, o);
    if (tdPluginVTable->initObject)
        rv &= tdPluginVTable->initObject (p, o);
    return rv;
}

static void tdOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (tdPluginVTable->finiObject)
        tdPluginVTable->finiObject (p, o);
    tdOptionsFiniObject (p, o);
}

static CompOption * tdOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) 0,
        (GetPluginObjectOptionsProc) tdOptionsGetScreenOptions
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool tdOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) tdOptionsSetScreenOption
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
tdOptionsGetMetadata (CompPlugin *plugin)
{
    return &tdOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!tdPluginVTable)
    {
        tdPluginVTable = getCompPluginInfo ();
        memcpy(&tdOptionsVTable, tdPluginVTable, sizeof(CompPluginVTable));
        tdOptionsVTable.getMetadata = tdOptionsGetMetadata;
        tdOptionsVTable.init = tdOptionsInit;
        tdOptionsVTable.fini = tdOptionsFini;
        tdOptionsVTable.initObject = tdOptionsInitObjectWrapper;
        tdOptionsVTable.finiObject = tdOptionsFiniObjectWrapper;
        tdOptionsVTable.getObjectOptions = tdOptionsGetObjectOptions;
	tdOptionsVTable.setObjectOption = tdOptionsSetObjectOption;
	
    }
    return &tdOptionsVTable;
}

