/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz.h>

#define _BENCH_OPTIONS_INTERNAL
#include "bench_options.h"

static int displayPrivateIndex;

static CompMetadata benchOptionsMetadata;

static CompPluginVTable *benchPluginVTable = NULL;
CompPluginVTable benchOptionsVTable;

#define GET_BENCH_OPTIONS_DISPLAY(d) \
        ((BenchOptionsDisplay *) (d)->privates[displayPrivateIndex].ptr)

#define BENCH_OPTIONS_DISPLAY(d) \
        BenchOptionsDisplay *od = GET_BENCH_OPTIONS_DISPLAY (d)

#define GET_BENCH_OPTIONS_SCREEN(s, od) \
        ((BenchOptionsScreen *) (s)->privates[(od)->screenPrivateIndex].ptr)

#define BENCH_OPTIONS_SCREEN(s) \
        BenchOptionsScreen *os = GET_BENCH_OPTIONS_SCREEN (s, GET_BENCH_OPTIONS_DISPLAY (s->display))

typedef struct _BenchOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[BenchDisplayOptionNum];
    benchDisplayOptionChangeNotifyProc notify[BenchDisplayOptionNum];
} BenchOptionsDisplay;

typedef struct _BenchOptionsScreen
{
} BenchOptionsScreen;

CompAction * benchGetInitiate (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return &od->opt[BenchDisplayOptionInitiate].value.action;
}

void benchSetInitiateInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    BENCH_OPTIONS_DISPLAY(d);
    od->opt[BenchDisplayOptionInitiate].value.action.initiate = init;
}

void benchSetInitiateTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    BENCH_OPTIONS_DISPLAY(d);
    od->opt[BenchDisplayOptionInitiate].value.action.terminate = term;
}

CompOption * benchGetInitiateOption (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return &od->opt[BenchDisplayOptionInitiate];
}

void benchSetInitiateNotify (CompDisplay *d, benchDisplayOptionChangeNotifyProc notify)
{
    BENCH_OPTIONS_DISPLAY(d);
    od->notify[BenchDisplayOptionInitiate] = notify;
}

Bool benchGetDisableLimiter (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return od->opt[BenchDisplayOptionDisableLimiter].value.b;
}

CompOption * benchGetDisableLimiterOption (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return &od->opt[BenchDisplayOptionDisableLimiter];
}

void benchSetDisableLimiterNotify (CompDisplay *d, benchDisplayOptionChangeNotifyProc notify)
{
    BENCH_OPTIONS_DISPLAY(d);
    od->notify[BenchDisplayOptionDisableLimiter] = notify;
}

Bool benchGetOutputScreen (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return od->opt[BenchDisplayOptionOutputScreen].value.b;
}

CompOption * benchGetOutputScreenOption (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return &od->opt[BenchDisplayOptionOutputScreen];
}

void benchSetOutputScreenNotify (CompDisplay *d, benchDisplayOptionChangeNotifyProc notify)
{
    BENCH_OPTIONS_DISPLAY(d);
    od->notify[BenchDisplayOptionOutputScreen] = notify;
}

int benchGetPositionX (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return od->opt[BenchDisplayOptionPositionX].value.i;
}

CompOption * benchGetPositionXOption (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return &od->opt[BenchDisplayOptionPositionX];
}

void benchSetPositionXNotify (CompDisplay *d, benchDisplayOptionChangeNotifyProc notify)
{
    BENCH_OPTIONS_DISPLAY(d);
    od->notify[BenchDisplayOptionPositionX] = notify;
}

int benchGetPositionY (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return od->opt[BenchDisplayOptionPositionY].value.i;
}

CompOption * benchGetPositionYOption (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return &od->opt[BenchDisplayOptionPositionY];
}

void benchSetPositionYNotify (CompDisplay *d, benchDisplayOptionChangeNotifyProc notify)
{
    BENCH_OPTIONS_DISPLAY(d);
    od->notify[BenchDisplayOptionPositionY] = notify;
}

Bool benchGetOutputConsole (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return od->opt[BenchDisplayOptionOutputConsole].value.b;
}

CompOption * benchGetOutputConsoleOption (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return &od->opt[BenchDisplayOptionOutputConsole];
}

void benchSetOutputConsoleNotify (CompDisplay *d, benchDisplayOptionChangeNotifyProc notify)
{
    BENCH_OPTIONS_DISPLAY(d);
    od->notify[BenchDisplayOptionOutputConsole] = notify;
}

int benchGetConsoleUpdateTime (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return od->opt[BenchDisplayOptionConsoleUpdateTime].value.i;
}

CompOption * benchGetConsoleUpdateTimeOption (CompDisplay *d)
{
    BENCH_OPTIONS_DISPLAY(d);
    return &od->opt[BenchDisplayOptionConsoleUpdateTime];
}

void benchSetConsoleUpdateTimeNotify (CompDisplay *d, benchDisplayOptionChangeNotifyProc notify)
{
    BENCH_OPTIONS_DISPLAY(d);
    od->notify[BenchDisplayOptionConsoleUpdateTime] = notify;
}

CompOption * benchGetDisplayOption (CompDisplay *d, BenchDisplayOptions num)
{
    BENCH_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

static const CompMetadataOptionInfo benchOptionsDisplayOptionInfo[] = {
    { "initiate", "action", 0, 0, 0 },
    { "disable_limiter", "bool", 0, 0, 0 },
    { "output_screen", "bool", 0, 0, 0 },
    { "position_x", "int", "<min>0</min><max>4096</max>", 0, 0 },
    { "position_y", "int", "<min>0</min><max>4096</max>", 0, 0 },
    { "output_console", "bool", 0, 0, 0 },
    { "console_update_time", "int", "<min>1</min><max>60</max>", 0, 0 },
};

static Bool benchOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, char *name, CompOptionValue *value)
{
    BENCH_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, BenchDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case BenchDisplayOptionInitiate:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[BenchDisplayOptionInitiate])
                (*od->notify[BenchDisplayOptionInitiate]) (d, o, BenchDisplayOptionInitiate);
            return TRUE;
        }
        break;
     case BenchDisplayOptionDisableLimiter:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[BenchDisplayOptionDisableLimiter])
                (*od->notify[BenchDisplayOptionDisableLimiter]) (d, o, BenchDisplayOptionDisableLimiter);
            return TRUE;
        }
        break;
     case BenchDisplayOptionOutputScreen:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[BenchDisplayOptionOutputScreen])
                (*od->notify[BenchDisplayOptionOutputScreen]) (d, o, BenchDisplayOptionOutputScreen);
            return TRUE;
        }
        break;
     case BenchDisplayOptionPositionX:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[BenchDisplayOptionPositionX])
                (*od->notify[BenchDisplayOptionPositionX]) (d, o, BenchDisplayOptionPositionX);
            return TRUE;
        }
        break;
     case BenchDisplayOptionPositionY:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[BenchDisplayOptionPositionY])
                (*od->notify[BenchDisplayOptionPositionY]) (d, o, BenchDisplayOptionPositionY);
            return TRUE;
        }
        break;
     case BenchDisplayOptionOutputConsole:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[BenchDisplayOptionOutputConsole])
                (*od->notify[BenchDisplayOptionOutputConsole]) (d, o, BenchDisplayOptionOutputConsole);
            return TRUE;
        }
        break;
     case BenchDisplayOptionConsoleUpdateTime:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[BenchDisplayOptionConsoleUpdateTime])
                (*od->notify[BenchDisplayOptionConsoleUpdateTime]) (d, o, BenchDisplayOptionConsoleUpdateTime);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * benchOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    BENCH_OPTIONS_DISPLAY(d);
    *count = BenchDisplayOptionNum;
    return od->opt;
}

static Bool benchOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    BenchOptionsScreen *os;
    
    BENCH_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(BenchOptionsScreen));
    if (!os)
        return FALSE;

    s->privates[od->screenPrivateIndex].ptr = os;

        if (benchPluginVTable && benchPluginVTable->initScreen)
        return benchPluginVTable->initScreen (p, s);
    return TRUE;
}

static void benchOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    if (benchPluginVTable && benchPluginVTable->finiScreen)
        return benchPluginVTable->finiScreen (p, s);

    BENCH_OPTIONS_SCREEN (s);

    free (os);
}

static Bool benchOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    BenchOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(BenchOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->privates[displayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &benchOptionsMetadata, benchOptionsDisplayOptionInfo, od->opt, BenchDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }
    if (benchPluginVTable && benchPluginVTable->initDisplay)
        return benchPluginVTable->initDisplay (p, d);
    return TRUE;
}

static void benchOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    if (benchPluginVTable && benchPluginVTable->finiDisplay)
        return benchPluginVTable->finiDisplay (p, d);

    BENCH_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, BenchDisplayOptionNum);

    free (od);
}

static Bool benchOptionsInit (CompPlugin *p)
{
    displayPrivateIndex = allocateDisplayPrivateIndex();
    if (displayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&benchOptionsMetadata, "bench",benchOptionsDisplayOptionInfo, BenchDisplayOptionNum, 0, 0))
        return FALSE;

    compAddMetadataFromFile (&benchOptionsMetadata, "bench");
    if (benchPluginVTable && benchPluginVTable->init)
        return benchPluginVTable->init (p);
    return TRUE;
}

static void benchOptionsFini (CompPlugin *p)
{
    if (benchPluginVTable && benchPluginVTable->fini)
        return benchPluginVTable->fini (p);

    if (displayPrivateIndex >= 0)
        freeDisplayPrivateIndex(displayPrivateIndex);

    compFiniMetadata (&benchOptionsMetadata);
}

static CompMetadata *
benchOptionsGetMetadata (CompPlugin *plugin)
{
    return &benchOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo (void)
{
    if (!benchPluginVTable)
    {
        benchPluginVTable = benchOptionsGetCompPluginInfo ();
        memcpy(&benchOptionsVTable, benchPluginVTable, sizeof(CompPluginVTable));
        benchOptionsVTable.getMetadata = benchOptionsGetMetadata;
        benchOptionsVTable.init = benchOptionsInit;
        benchOptionsVTable.fini = benchOptionsFini;
        benchOptionsVTable.initDisplay = benchOptionsInitDisplay;
        benchOptionsVTable.finiDisplay = benchOptionsFiniDisplay;
        benchOptionsVTable.initScreen = benchOptionsInitScreen;
        benchOptionsVTable.finiScreen = benchOptionsFiniScreen;
        benchOptionsVTable.getDisplayOptions = benchOptionsGetDisplayOptions;
	benchOptionsVTable.setDisplayOption = benchOptionsSetDisplayOption;
	
    }
    return &benchOptionsVTable;
}

