#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# status tests
# Copyright © 2003 Colin Walters <walters@verbum.org>
# Copyright (C) 2004 Canonical Limited
#   Authors: Robert Collins <robert.collins@canonical.com>
#            Rob Weir <rob.weir@canonical.com>
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_with_trivial_archives

test_class "status"

setup () {
  tla get jane@example.com--2003/hello-world--mainline--1.0 hello-world
  copy_tree hello-world hello-world.good
  cd hello-world
}  

assert_output_nonclean () {
   tla status "$@" 1>../status-output || test $? = 1
}  

verify_cleanup () {
  cd ..
  rm -rf ',status'
  rm -f status-output
  rm -rf hello-world
  mv hello-world.good hello-world
}
  
# begin_test "null change output"
# setup
# tla changes > ../changes-output
# file_is_empty ../changes-output
# verify_cleanup
# end_test 

begin_test "no changes clean tree"
setup
tla status --strict
verify_cleanup
end_test 

begin_test "single file modification clean tree"
setup
sed -e 's/Hello world/Hello, world/' < hello-world.c > hello-world.c.new
mv hello-world.c.new hello-world.c
assert_output_nonclean
file_matches '^ M [[:space:]]*hello-world.c' ../status-output
verify_cleanup
end_test 

begin_test "no changes bad tree"
setup
touch phwoar.c
assert_output_nonclean
file_matches '^phwoar.c' ../status-output
end_test

begin_test "single file modification bad tree only-lint"
setup
touch phwoar.c
echo "Hello to thee" > hello-world.c
assert_output_nonclean --lint
file_matches '^ M [[:space:]]*hello-world.c' ../status-output && test_fail "more than lint occured"
file_matches '^phwoar.c' ../status-output
verify_cleanup
end_test 

begin_test "single file modification soft-lint error tree"
setup
touch phwoar.c
echo "Hello to thee" > hello-world.c
assert_output_nonclean
file_matches '^ M [[:space:]]*hello-world.c' ../status-output || test_fail "only lint occured"
file_matches '^phwoar.c' ../status-output || test_fail "lint did not occur"
verify_cleanup
end_test

clean_workdir
