/* inifile.h:
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2005 Canonical Limited
 * 	Authors: Robert Collins <robert.collins@canonical.com>
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBINIFILE__INIFILE_H
#define INCLUDE__LIBINIFILE__INIFILE_H

#include "libawk/relational.h"

typedef struct inifile_
{
  rel_table content;
} inifile_t;

typedef enum inifile_line_type_
{
    INIFILE_COMMENT,
    INIFILE_SECTION,
    INIFILE_KEY
} inifile_line_type_t;

extern void inifile_init  (inifile_t *inifile);
extern void inifile_finalise (inifile_t *inifile);
extern int inifile_load (inifile_t *inifile, t_uchar const *filename);
extern int inifile_save_merge (inifile_t *inifile, int merge_index, t_uchar const *filename);
extern int inifile_process_text (inifile_t *inifile, t_uchar const *content);
extern t_uchar *inifile_get_text (inifile_t *inifile);
extern t_uchar *inifile_get_text_merge (inifile_t *inifile, int merge_index);
extern rel_table inifile_get_section (inifile_t *inifile, t_uchar const *section);
extern rel_table inifile_get_key_values (inifile_t *inifile, t_uchar const *section, t_uchar const *key);
extern void inifile_add_key (inifile_t *inifile, t_uchar const *section, t_uchar const *key, t_uchar const * value, t_uchar const * comment);
extern void inifile_update_key (inifile_t *inifile, t_uchar const *section, t_uchar const *key, int index, t_uchar const * value, t_uchar const * comment);
extern void inifile_remove_key (inifile_t *inifile, t_uchar const *section, t_uchar const *key, int index);
extern t_uchar * inifile_get_single_string (inifile_t *inifile, t_uchar const * section, t_uchar const * key, t_uchar const * default_value);
extern void inifile_set_single_string (inifile_t *inifile, t_uchar const * section, t_uchar const * key, t_uchar const * value, t_uchar const * comment);
/* internals exposed solely for testing */
extern inifile_line_type_t inifile_line_type (t_uchar const *line);
extern t_uchar * inifile_section_name (t_uchar const *line);
extern t_uchar * inifile_key_name (t_uchar const *line);
extern t_uchar * inifile_value (t_uchar const *line);
extern t_uchar * inifile_comment (t_uchar const *line);

#endif /* INCLUDE__LIBINIFILE__INIFILE_H */
