/* associative.h:
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__FILE_UTILS__ASSOCIATIVE_H
#define INCLUDE__FILE_UTILS__ASSOCIATIVE_H


#include "hackerlab/machine/types.h"
#include "libawk/relational.h"



typedef struct assoc_table_incomplete_type * assoc_table;
/* leaky abstraction. soshumi */
extern struct hashtree_rules assoc_rules;



/* automatically generated __STDC__ prototypes */
extern void assoc_set (assoc_table * vtable, t_uchar const * key, t_uchar const * value);
extern t_uchar * assoc_ref (assoc_table vtable, t_uchar const * key);
extern void assoc_del (assoc_table vtable, t_uchar * key);
extern void free_assoc_table (assoc_table table);
extern rel_table assoc_intersection(assoc_table left, assoc_table right);
#endif  /* INCLUDE__FILE_UTILS__ASSOCIATIVE_H */


/* tag: Tom Lord Sat Jan  5 15:26:10 2002 (associative.h)
 */
