/* project-tree.h:
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__PROJECT_TREE_H
#define INCLUDE__LIBARCH__PROJECT_TREE_H


#include "hackerlab/machine/types.h"
#include "libawk/relational.h"
#include "libawk/associative.h"
#include "libarch/patch-logs.h"



#define ARCH_PROJECT_TREE_ANCESTRY_FILE "{arch}/+ancestry"

enum arch_tree_state
{
  arch_tree_in_ok_state = 0,
  arch_tree_in_resolve_conflicts,
  arch_tree_in_commit_definite,
  arch_tree_in_mid_commit,
};

typedef struct arch_project_tree
{
    t_uchar * root;
    t_uchar * archive;
    t_uchar * fqversion;
    t_uchar * fqrevision;
    rel_table ancestry;
    t_uchar * version;  /* deprecated */
    t_uchar * revision; /* deprecated */
    assoc_table local_ancestry; /* untrusted local log data */
    arch_patch_log_dir_t *patch_logs; /* patch logs data */
} arch_project_tree_t;


extern t_uchar * arch_tree_format_string (void);
extern void arch_init_tree (t_uchar * tree_root);
extern t_uchar * arch_tree_root (enum arch_tree_state * state, t_uchar * input_dir, int accurate);
extern t_uchar * arch_tree_ctl_dir (t_uchar const * tree_root);
extern void arch_set_tree_version (t_uchar const * tree_root, t_uchar const * fully_qualified_version);
extern t_uchar * arch_tree_version (t_uchar const * tree_root);
extern t_uchar * arch_try_tree_version (t_uchar * cmd);
extern t_uchar * arch_try_tree_version_dir (t_uchar * cmd, t_uchar * dir);
extern void arch_start_tree_commit (t_uchar * tree_root, t_uchar * log);
extern void arch_finish_tree_commit (t_uchar * tree_root, t_uchar * archive, t_uchar * revision, t_uchar * changelog_loc);
extern void arch_abort_tree_commit (t_uchar * tree_root, t_uchar * archive, t_uchar * revision);
extern void arch_project_tree_init (arch_project_tree_t *tree, t_uchar const * tree_root);
extern void arch_project_tree_finalise (arch_project_tree_t *tree);
extern t_uchar * arch_project_tree_file_contents(struct arch_project_tree *tree, t_uchar const *rel_path);
extern int arch_project_tree_file_exists(struct arch_project_tree *tree, t_uchar const *rel_path);
extern rel_table arch_project_tree_ancestry (struct arch_project_tree *tree);
extern int arch_project_tree_has_patch (arch_project_tree_t *tree, t_uchar const *patch_id);
extern t_uchar * arch_project_tree_patch_filename (arch_project_tree_t *tree, t_uchar const *patch_id);
/* this s here due to layering not being fully reorganised */
extern t_uchar * arch_highest_patch_level_before (arch_project_tree_t * tree, t_uchar const *fqrevision_before);
extern t_uchar * arch_project_tree_patch_log (arch_project_tree_t * tree, t_uchar const * fqrevision);
#endif  /* INCLUDE__LIBARCH__PROJECT_TREE_H */


/* tag: Tom Lord Sat Jan  5 15:26:10 2002 (project-tree.h)
 */
