/* ancestry.c:
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2005 Canonical Limited
 *        Authors: Robert Collins <robert.collins@canonical.com>
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/bugs/panic.h"
#include "hackerlab/char/str.h"
#include "libarch/namespace.h"
#include "libarch/patch-id.h"

void
arch_patch_id_init (arch_patch_id *patch, t_uchar const *patch_id)
{
    patch->patch_id = str_save (0, patch_id);
    patch->archive = NULL;
    patch->branch = NULL;
    patch->version = NULL;
    patch->revision = NULL;
    patch->patchlevel = NULL;
}

void
arch_patch_id_init_archive (arch_patch_id *patch, t_uchar const *archive, t_uchar const *revision)
{
    t_uchar *fqrevision = str_alloc_cat_many (0, archive, "/", revision, str_end);
    arch_patch_id_init (patch, fqrevision);
    lim_free (0, fqrevision);
}

void 
arch_patch_id_finalise (arch_patch_id *patch)
{
    lim_free (0, patch->patch_id);
    patch->patch_id = NULL;
    lim_free (0, patch->archive);
    patch->archive = NULL;
    lim_free (0, patch->branch);
    patch->branch = NULL;
    lim_free (0, patch->version);
    patch->version = NULL;
    lim_free (0, patch->revision);
    patch->revision = NULL;
    lim_free (0, patch->patchlevel);
    patch->patchlevel = NULL;
}

t_uchar *
arch_patch_id_archive (arch_patch_id *patch)
{
    if (!patch->archive)
        patch->archive = arch_parse_package_name (arch_ret_archive, 0, patch->patch_id);
    return patch->archive;
}

t_uchar *
arch_patch_id_branch (arch_patch_id *patch)
{
    if (!patch->branch)
        patch->branch = arch_fully_qualify (arch_patch_id_archive(patch), arch_patch_id_version (patch));
    return patch->branch;
}

t_uchar *
arch_patch_id_version (arch_patch_id *patch)
{
    if (!patch->version)
        patch->version = arch_parse_package_name (arch_ret_package_version, 0, patch->patch_id);
    return patch->version;
}

t_uchar *
arch_patch_id_revision (arch_patch_id *patch)
{
    if (!patch->revision)
        patch->revision = arch_parse_package_name (arch_ret_non_archive, 0, patch->patch_id);
    return patch->revision;
}

t_uchar *
arch_patch_id_patch_id (arch_patch_id *patch)
{
    return patch->patch_id;
}

t_uchar *
arch_patch_id_patchlevel (arch_patch_id *patch)
{
    if (!patch->patchlevel)
        patch->patchlevel = arch_parse_package_name (arch_ret_patch_level, 0, patch->patch_id);
    return patch->patchlevel;
}
