#!/usr/bin/env python

from distutils.core import setup
from DistUtilsExtra.command import *
import glob
import os
import re

# look/set what version we have
changelog = "debian/changelog"
if os.path.exists(changelog):
    head = open(changelog).readline()
    match = re.compile(".*\((.*)\).*").match(head)
    if match:
        version = match.group(1)
        f = open("AptUrl/Version.py", "w")
        f.write("VERSION=\"%s\"\n" % version)
        f.close()

GETTEXT_NAME="apturl"
I18NFILES = []
for filepath in glob.glob("po/mo/*/LC_MESSAGES/*.mo"):
    lang = filepath[len("po/mo/"):]
    targetpath = os.path.dirname(os.path.join("share/locale",lang))
    I18NFILES.append((targetpath, [filepath]))

setup(name='apturl',
      version=version,
      packages=['AptUrl'],
      scripts=['apturl'],
      data_files=[('share/apturl/',
                   ["data/apturl.glade"]),
                  ('share/firefox/defaults/pref/',
                   ["data/apturl.js"]),
                  ('../etc/firefox-3.0/pref/',
                   ["data/apturl.js"]),
                  ('share/services/',
                   ["data/apturl.protocol"]),
                 ]+I18NFILES,
      cmdclass = { "build" : build_extra.build_extra,
                   "build_i18n" :  build_i18n.build_i18n,
                   "build_help" :  build_help.build_help,
                   "build_icons" :  build_icons.build_icons }
      )
