/*
 * ɤߤñξǡ¤ե
 * Ϥ뤿Υ
 *
 * ǡ¤ѹ䤹뤿mkdic.cʬΥ(2005/7/8)
 *
 * output_word_dict()ƤӽФ
 *
 * Copyright (C) 2000-2005 TABATA Yusuke
 */
#include <stdio.h>
#include <string.h>
#include <word_dic.h>
#include "mkdic.h"

extern FILE *page_out, *page_index_out;
extern FILE *yomi_entry_index_out, *yomi_entry_out;

/** ĤɤߤФñƤϤ */
static int
output_yomi_entry(struct yomi_entry *ye)
{
  int i;
  int count = 0;

  if (!ye) {
    return 0;
  }
  /* ñϤ */
  for (i = 0; i < ye->nr_entries; i++) {
    struct word_entry *we = &ye->entries[i];
    /**/
    if (!we->freq) {
      continue;
    }
    if (i > 0) {
      /* ܰʹߤ϶򤫤Ϥޤ */
      count += fprintf(yomi_entry_out, " ");
    }
    /* ʻ٤Ϥ */
    if (i == 0 ||
	(strcmp(ye->entries[i-1].word, we->word) ||
	 strcmp(ye->entries[i-1].wt_name, we->wt_name) ||
	 ye->entries[i-1].freq != we->freq)) {
      count += fprintf(yomi_entry_out, "%s", we->wt_name);
      if (we->freq != 0) {
	count += fprintf(yomi_entry_out, "*%d", we->freq);
      }
      count += fprintf(yomi_entry_out, " ");
    }
    /* ñϤ꤬ñid */
    we->offset = count + ye->offset;
    /* ñϤ */
    count += fprintf(yomi_entry_out, "%s", we->word);
  }

  fputc(0, yomi_entry_out);
  return count + 1;
}

/* 2ĤʸζʬĹ */
static int
common_len(xstr *s1, xstr *s2)
{
  int m,i;
  if (!s1 || !s2) {
    return 0;
  }
  if (s1->len < s2->len) {
    m = s1->len;
  }else{
    m = s2->len;
  }
  for (i = 0; i < m; i++) {
    if (s1->str[i] != s2->str[i]) {
      return i;
    }
  }
  return m;
}

/*
 * 2ĤʸκʬϤ
 * AAA ABBB Ȥ2Ĥʸ򸫤ˤ
 * ABBBAAAΤ2ʸäBBBդΤȤ
 * \0x2BBBȽϤ롣
 */
static int
output_diff(xstr *p, xstr *c)
{
  int i, m, len = 1;
  m = common_len(p, c);
  if (p && p->len > m) {
    fprintf(page_out, "%c", p->len - m + 1);
  } else {
    fprintf(page_out, "%c", 1);
  }
  for (i = m; i < c-> len; i++) {
    char buf[8];
    len += anthy_sputxchar(buf, c->str[i], 0);
    fputs(buf, page_out);
  }
  return len;
}

static void
begin_new_page(int i)
{
  fputc(0, page_out);
  write_nl(page_index_out, i);
}

static void
output_entry_index(int i)
{
  write_nl(yomi_entry_index_out, i);
}

/* ɤߤʸ󤫤եΰ(offset)뤿Υơ֥
 * page_out, page_index_out, yomi_entry_index_out˽
 */
static void
generate_yomi_to_offset_map(struct yomi_entry_list *yl)
{
  int i;
  struct yomi_entry *ye = NULL;
  xstr *prev = NULL;
  int page_index = 0;
  /* ɤߤ(offset)׻ǡ¤ */

  /* ޤǽɤߤФ륨ȥΥǥå񤭽Ф */
  write_nl(page_index_out, page_index);
  /**/
  for (i = 0; i < yl->nr_valid_entries; i++) {
    ye = yl->ye_array[i];
    /* ڡγ */
    if ((i % WORDS_PER_PAGE) == 0 && (i != 0)) {
      page_index ++;
      prev = NULL;
      begin_new_page(page_index);
    }

    /* ɤߤбϤ */
    page_index += output_diff(prev, ye->index_xstr);

    output_entry_index(ye->offset);
    /***/
    prev = ye->index_xstr;
  }
}

/** ñ켭Ϥ
 * ޤΤȤ˼ΥեåȤ׻ */
void
output_word_dict(struct yomi_entry_list *yl)
{
  int entry_index = 0;
  int i;
  struct yomi_entry *ye = NULL;

  /* ɤߤФ롼 */
  for (i = 0; i < yl->nr_valid_entries; i++) {
    /* ñϤơեΰ(offset)׻ */
    ye = yl->ye_array[i];
    ye->offset = entry_index;
    entry_index += output_yomi_entry(ye);
  }
  /* ɤߤʸ󤫤եΰ(offset)뤿Υơ֥ */
  generate_yomi_to_offset_map(yl);

  /* Ǹɤߤλ */
  entry_index += output_yomi_entry(ye);
  write_nl(yomi_entry_index_out, entry_index);
  write_nl(page_index_out, 0);

  /**/
  printf("Total %d indexes, %d words, (%d pages).\n",
	 yl->nr_valid_entries,
	 yl->nr_words,
	 yl->nr_valid_entries / WORDS_PER_PAGE + 1);
}
