/* -*- C++ -*- file adept/commitprogress.h
   written by Peter Rockai <me@mornfall.net> */

#include <kde_terminal_interface.h>
#include <adept/dpkgpm-gui.h>
#include <adept/commitprogressui.h>
#include <kparts/part.h>

#ifndef EPT_COMMITPROGRESS_H
#define EPT_COMMITPROGRESS_H

namespace adept {

class CommitProgress : public CommitProgressUi
{
    Q_OBJECT
public:
    CommitProgress( QWidget *p = 0, const char *n = 0 );

    ExtTerminalInterface *terminal() {
        return static_cast<ExtTerminalInterface*>(
            m_konsole->qt_cast( "ExtTerminalInterface" ) );
    }

    // needs to be called before aptFront::init() :'((
    static void initSystem();
    virtual bool eventFilter( QObject *o, QEvent *e );

public slots:
    void updateProgress( int p, QString msg );
    void toggleDetails();
protected:
    void loadKonsole();
    KParts::Part *m_konsole;
    static adept::PkgSystem *s_system; // bla...
};

}


#endif
